/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes"})
public final class EntityConverter {
    private static final String escapeAllowedString = "\\!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}\\~";
    private static final Map<Character, String> replacements;
    private static final Regex REGEX;
    private static final Regex REGEX_ESCAPES;
    public static final EntityConverter INSTANCE;

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text, (Function1)new Function1<MatchResult, CharSequence>(processEntities){
            final /* synthetic */ boolean $processEntities;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                CharSequence charSequence;
                block20: {
                    Object object;
                    block22: {
                        void startIndex$iv;
                        char it;
                        String $receiver$iv;
                        block23: {
                            Integer code;
                            Integer n;
                            MatchGroupCollection g;
                            block21: {
                                block19: {
                                    Intrinsics.checkParameterIsNotNull((Object)match, (String)"match");
                                    g = match.getGroups();
                                    if (g.size() <= 5 || g.get(5) == null) break block19;
                                    MatchGroup matchGroup = g.get(5);
                                    if (matchGroup == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    char c = matchGroup.getValue().charAt(0);
                                    String string = (String)EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE).get(Character.valueOf(c));
                                    charSequence = string != null ? (CharSequence)string : (CharSequence)String.valueOf(c);
                                    break block20;
                                }
                                if (g.get(4) == null) break block21;
                                Map map = EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE);
                                MatchGroup matchGroup = g.get(4);
                                if (matchGroup == null) {
                                    Intrinsics.throwNpe();
                                }
                                if ((object = (String)map.get(Character.valueOf(matchGroup.getValue().charAt(0)))) == null) {
                                    object = match.getValue();
                                }
                                break block22;
                            }
                            if (!this.$processEntities) {
                                n = null;
                            } else if (g.get(1) != null) {
                                n = Entities.INSTANCE.getMap().get(match.getValue());
                            } else if (g.get(2) != null) {
                                MatchGroup matchGroup = g.get(2);
                                if (matchGroup == null) {
                                    Intrinsics.throwNpe();
                                }
                                n = Integer.parseInt(matchGroup.getValue());
                            } else if (g.get(3) != null) {
                                MatchGroup matchGroup = g.get(3);
                                if (matchGroup == null) {
                                    Intrinsics.throwNpe();
                                }
                                n = Integer.parseInt(matchGroup.getValue(), 16);
                            } else {
                                n = null;
                            }
                            if ((object = (code = n)) == null) break block23;
                            Character c = Character.valueOf((char)((Number)object).intValue());
                            it = ((Character)((Object)$receiver$iv)).charValue();
                            Object object2 = (String)EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE).get(Character.valueOf(it));
                            if (object2 == null) {
                                object2 = object = String.valueOf(it);
                            }
                            if (object2 != null) break block22;
                        }
                        $receiver$iv = match.getValue();
                        it = '\u0001';
                        StringBuilder stringBuilder = new StringBuilder().append("&amp;");
                        String string = $receiver$iv;
                        if (string == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.substring((int)startIndex$iv);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        String string3 = string2;
                        object = stringBuilder.append(string3).toString();
                    }
                    charSequence = (CharSequence)object;
                }
                return charSequence;
            }
            {
                this.$processEntities = bl;
                super(1);
            }
        });
    }

    private EntityConverter() {
        INSTANCE = this;
        escapeAllowedString = escapeAllowedString;
        replacements = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)"&quot;"), TuplesKt.to((Object)Character.valueOf('&'), (Object)"&amp;"), TuplesKt.to((Object)Character.valueOf('<'), (Object)"&lt;"), TuplesKt.to((Object)Character.valueOf('>'), (Object)"&gt;")});
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|" + "\\" + "\\" + "([" + escapeAllowedString + "])");
    }

    static {
        new EntityConverter();
    }

    @NotNull
    public static final /* synthetic */ Map access$getReplacements$p(EntityConverter $this) {
        EntityConverter entityConverter = $this;
        return replacements;
    }
}

