/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdDisplayList;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.WizardStepHeaderPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdListDialog
extends FrameWrapper
implements AvdUiAction.AvdInfoProvider {
    private final Project myProject;
    private AvdDisplayList myAvdDisplayList;

    public AvdListDialog(@Nullable Project project) {
        super(project);
        this.myProject = project;
        this.myAvdDisplayList = new AvdDisplayList(this, project);
        this.myAvdDisplayList.setBorder(new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        this.setTitle("Android Virtual Device Manager");
        this.setDimensionKey(this.getClass().getName());
    }

    public void init() {
        JPanel root = new JPanel(new BorderLayout());
        this.setComponent(root);
        WizardStepHeaderPanel northPanel = WizardStepHeaderPanel.create(WizardConstants.ANDROID_NPW_HEADER_COLOR, AndroidIcons.Wizards.NewProjectMascotGreen, null, "Your Virtual Devices", "Android Studio");
        root.add((Component)northPanel, "North");
        root.add((Component)this.myAvdDisplayList, "Center");
    }

    @Override
    @Nullable
    public AvdInfo getAvdInfo() {
        return null;
    }

    @Override
    public void refreshAvds() {
        this.myAvdDisplayList.refreshAvds();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        AvdDisplayList avdDisplayList = this.myAvdDisplayList;
        if (avdDisplayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdListDialog", "getComponent"));
        }
        return avdDisplayList;
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myAvdDisplayList.getAvdInfo();
    }
}

