/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HaxmWizard
extends DynamicWizard {
    public HaxmWizard() {
        super(null, null, "HAXM");
        HaxmPath path = new HaxmPath(this.myHost);
        this.addPath(path);
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Finishing install..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/HaxmWizard", "getProgressTitle"));
        }
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return "HAXM Installation";
    }

    private class HaxmPath
    extends DynamicWizardPath {
        DynamicWizardHost myHost;

        public HaxmPath(DynamicWizardHost host) {
            this.myHost = host;
        }

        @Override
        protected void init() {
            ScopedStateStore.Key<Boolean> canShow = ScopedStateStore.createKey("ShowHaxmSteps", ScopedStateStore.Scope.PATH, Boolean.class);
            this.myState.put(canShow, true);
            Haxm haxm = new Haxm(this.getState(), canShow);
            for (IPkgDesc desc : haxm.getRequiredSdkPackages(null)) {
                this.myState.listPush(WizardConstants.INSTALL_REQUESTS_KEY, desc);
            }
            for (DynamicWizardStep step : haxm.createSteps()) {
                this.addStep(step);
            }
            this.addStep(new LicenseAgreementStep(this.getWizard().getDisposable()));
            SetupProgressStep progressStep = new SetupProgressStep(this.getWizard().getDisposable(), haxm, this.myHost);
            this.addStep(progressStep);
            haxm.init(progressStep);
        }

        @Override
        @NotNull
        public String getPathName() {
            if ("Haxm Path" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/HaxmWizard$HaxmPath", "getPathName"));
            }
            return "Haxm Path";
        }

        @Override
        public boolean performFinishingActions() {
            return false;
        }
    }

    private static class SetupProgressStep
    extends ProgressStep {
        private Haxm myHaxm;
        private final AtomicBoolean myIsBusy = new AtomicBoolean(false);
        private DynamicWizardHost myHost;

        public SetupProgressStep(Disposable parentDisposable, Haxm haxm, DynamicWizardHost host) {
            super(parentDisposable);
            this.myHaxm = haxm;
            this.myHost = host;
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        @Override
        protected void execute() {
            this.myIsBusy.set(true);
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

                @Override
                public void run() {
                    try {
                        this.setupHaxm();
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).error((Throwable)e);
                        this.showConsole();
                        this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    finally {
                        myIsBusy.set(false);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        private void setupHaxm() throws IOException {
            final InstallContext installContext = new InstallContext(FileUtil.createTempDirectory((String)"AndroidStudio", (String)"Haxm", (boolean)true), this);
            File destination = AndroidSdkUtils.tryToChooseAndroidSdk().getLocation();
            ArrayList selectedComponents = Lists.newArrayList((Object[])new Haxm[]{this.myHaxm});
            installContext.print("Looking for SDK updates...\n", ConsoleViewContentType.NORMAL_OUTPUT);
            InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, new ComponentInstaller(null, true), 0.5);
            try {
                install.then(InstallOperation.wrap(installContext, new Function<File, File>(){

                    public File apply(@Nullable File input) {
                        myHaxm.configure(installContext, input);
                        return input;
                    }
                }, 0.5)).execute(destination);
            }
            catch (InstallationCancelledException e) {
                installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            }
            catch (WizardException e) {
                throw new RuntimeException(e);
            }
            installContext.print("Done", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }
}

