/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.AndroidVariationPaletteItem;
import com.android.tools.idea.designer.FillPolicy;
import com.android.tools.idea.designer.ResizePolicy;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AndroidMetaModel
extends MetaModel {
    static final String ATTR_RESIZE = "resize";
    static final String ATTR_FILL = "fill";
    private ResizePolicy myResizePolicy;
    private FillPolicy myFillPolicy;

    public AndroidMetaModel(Class<RadComponent> model, String target, String tag) {
        super(model, target, tag);
    }

    public void initializeFrom(@NotNull Element element) {
        FillPolicy fillPolicy;
        String fill;
        ResizePolicy resizePolicy;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/designer/AndroidMetaModel", "initializeFrom"));
        }
        String resize = element.getAttributeValue(ATTR_RESIZE);
        if (resize != null && (resizePolicy = ResizePolicy.get(resize)) != null) {
            this.myResizePolicy = resizePolicy;
        }
        if ((fill = element.getAttributeValue(ATTR_FILL)) != null && (fillPolicy = FillPolicy.get(fill)) != null) {
            this.myFillPolicy = fillPolicy;
        }
    }

    @NotNull
    public ResizePolicy getResizePolicy() {
        AndroidVariationPaletteItem item;
        ResizePolicy policy;
        PaletteItem paletteItem = this.getPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (policy = (item = (AndroidVariationPaletteItem)paletteItem).getResizePolicy()) != null) {
            ResizePolicy resizePolicy = policy;
            if (resizePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/AndroidMetaModel", "getResizePolicy"));
            }
            return resizePolicy;
        }
        ResizePolicy resizePolicy = this.myResizePolicy != null ? this.myResizePolicy : ResizePolicy.full();
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/AndroidMetaModel", "getResizePolicy"));
        }
        return resizePolicy;
    }

    @NotNull
    public FillPolicy getFillPolicy() {
        AndroidVariationPaletteItem item;
        FillPolicy fill;
        PaletteItem paletteItem = this.getPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (fill = (item = (AndroidVariationPaletteItem)paletteItem).getFillPolicy()) != null) {
            FillPolicy fillPolicy = fill;
            if (fillPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/AndroidMetaModel", "getFillPolicy"));
            }
            return fillPolicy;
        }
        FillPolicy fillPolicy = this.myFillPolicy != null ? this.myFillPolicy : FillPolicy.NONE;
        if (fillPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/AndroidMetaModel", "getFillPolicy"));
        }
        return fillPolicy;
    }
}

