/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.SeparatedList;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JSeparator;
import javax.swing.MutableComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentThemesListModel
extends AbstractListModel
implements MutableComboBoxModel {
    private static final JSeparator SEPARATOR = new JSeparator(0);
    private static final int MAX_SIZE = 5;
    public static final String SHOW_ALL_THEMES = "Show all themes";
    private Object mySelectedObject;
    private final SeparatedList myAllItems;
    private final ArrayList<String> myRecentParentThemeList;

    public ParentThemesListModel(@NotNull List<String> defaultThemeList, @Nullable String defaultParent) {
        if (defaultThemeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultThemeList", "com/android/tools/idea/editors/theme/ParentThemesListModel", "<init>"));
        }
        this.myRecentParentThemeList = new ArrayList();
        if (defaultParent != null && !defaultThemeList.contains(defaultParent)) {
            this.myRecentParentThemeList.add(defaultParent);
        }
        this.myAllItems = new SeparatedList(SEPARATOR, SeparatedList.group(this.myRecentParentThemeList), SeparatedList.group(ImmutableList.copyOf(defaultThemeList)), SeparatedList.group(SHOW_ALL_THEMES));
        this.setSelectedItem(defaultParent == null ? this.myAllItems.get(0) : defaultParent);
    }

    @Override
    public int getSize() {
        return this.myAllItems.size();
    }

    @Override
    @NotNull
    public Object getElementAt(int index) {
        Object object = this.myAllItems.get(index);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ParentThemesListModel", "getElementAt"));
        }
        return object;
    }

    @Override
    public void setSelectedItem(@Nullable Object anItem) {
        if (anItem instanceof JSeparator) {
            return;
        }
        if (!Objects.equal((Object)this.mySelectedObject, (Object)anItem)) {
            this.mySelectedObject = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    @Nullable
    public Object getSelectedItem() {
        return this.mySelectedObject;
    }

    public void addElement(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.myRecentParentThemeList.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void insertElementAt(Object obj, int index) {
        assert (obj instanceof String);
        this.myRecentParentThemeList.add(index, (String)obj);
        this.fireIntervalAdded(this, index, index);
        if (this.myRecentParentThemeList.size() > 5) {
            this.removeElementAt(5);
        }
    }

    @Override
    public void removeElementAt(int index) {
        this.myRecentParentThemeList.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }
}

