/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class JavaProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myModuleName;
    @NotNull
    private Collection<JavaModuleContentRoot> myContentRoots;
    @NotNull
    private Collection<JavaModuleDependency> myJavaModuleDependencies;
    @NotNull
    private Collection<JarLibraryDependency> myJarLibraryDependencies;
    @Nullable
    private Map<String, Set<File>> myArtifactsByConfiguration;
    @Nullable
    private ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private File myBuildFolderPath;
    @Nullable
    private String myLanguageLevel;
    private boolean myBuildable;
    private boolean myAndroidProjectWithoutVariants;

    @NotNull
    public static JavaProject create(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel extendedModel, boolean androidProjectWithoutVariants) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/JavaProject", "create"));
        }
        Collection<? extends IdeaContentRoot> contentRoots = JavaProject.getContentRoots(ideaModule, extendedModel);
        Map artifactsByConfiguration = Maps.newHashMap();
        if (extendedModel != null) {
            artifactsByConfiguration = extendedModel.getArtifactsByConfiguration();
        }
        ExtIdeaCompilerOutput compilerOutput = extendedModel != null ? extendedModel.getCompilerOutput() : null;
        File buildFolderPath = ideaModule.getGradleProject().getBuildDirectory();
        boolean buildable = !androidProjectWithoutVariants && JavaProject.isBuildable(ideaModule);
        String languageLevel = null;
        if (extendedModel != null) {
            languageLevel = extendedModel.getJavaSourceCompatibility();
        }
        JavaProject javaProject = new JavaProject(ideaModule.getName(), contentRoots, JavaProject.getDependencies(ideaModule), artifactsByConfiguration, compilerOutput, buildFolderPath, languageLevel, buildable, androidProjectWithoutVariants);
        if (javaProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "create"));
        }
        return javaProject;
    }

    @NotNull
    private static Collection<? extends IdeaContentRoot> getContentRoots(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel extendedModel) {
        DomainObjectSet contentRoots;
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/JavaProject", "getContentRoots"));
        }
        DomainObjectSet domainObjectSet = contentRoots = extendedModel != null ? extendedModel.getContentRoots() : null;
        if (contentRoots != null) {
            DomainObjectSet domainObjectSet2 = contentRoots;
            if (domainObjectSet2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getContentRoots"));
            }
            return domainObjectSet2;
        }
        contentRoots = ideaModule.getContentRoots();
        if (contentRoots != null) {
            DomainObjectSet domainObjectSet3 = contentRoots;
            if (domainObjectSet3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getContentRoots"));
            }
            return domainObjectSet3;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getContentRoots"));
        }
        return list;
    }

    @NotNull
    private static List<? extends IdeaDependency> getDependencies(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/JavaProject", "getDependencies"));
        }
        List dependencies = ideaModule.getDependencies().getAll();
        if (dependencies != null) {
            List list = dependencies;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getDependencies"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getDependencies"));
        }
        return list;
    }

    private static boolean isBuildable(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/JavaProject", "isBuildable"));
        }
        for (GradleTask task : ideaModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    public JavaProject(@NotNull String name, @NotNull Collection<? extends IdeaContentRoot> contentRoots, @NotNull List<? extends IdeaDependency> dependencies, @Nullable Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable, boolean androidProjectWithoutVariants) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/JavaProject", "<init>"));
        }
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "com/android/tools/idea/gradle/JavaProject", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/JavaProject", "<init>"));
        }
        this.myContentRoots = Lists.newArrayList();
        this.myJavaModuleDependencies = Lists.newArrayList();
        this.myJarLibraryDependencies = Lists.newArrayList();
        this.myModuleName = name;
        for (IdeaContentRoot ideaContentRoot : contentRoots) {
            if (ideaContentRoot == null) continue;
            this.myContentRoots.add(JavaModuleContentRoot.copy(ideaContentRoot));
        }
        for (IdeaDependency ideaDependency : dependencies) {
            JavaModuleDependency moduleDependency;
            if (ideaDependency instanceof IdeaSingleEntryLibraryDependency) {
                JarLibraryDependency libraryDependency = JarLibraryDependency.copy((IdeaSingleEntryLibraryDependency)ideaDependency);
                if (libraryDependency == null) continue;
                this.myJarLibraryDependencies.add(libraryDependency);
                continue;
            }
            if (!(ideaDependency instanceof IdeaModuleDependency) || (moduleDependency = JavaModuleDependency.copy((IdeaModuleDependency)ideaDependency)) == null) continue;
            this.myJavaModuleDependencies.add(moduleDependency);
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration;
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidProjectWithoutVariants = androidProjectWithoutVariants;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        Collection<JavaModuleContentRoot> collection = this.myContentRoots;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getContentRoots"));
        }
        return collection;
    }

    public boolean containsSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/JavaProject", "containsSourceFile"));
        }
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaProject.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/android/tools/idea/gradle/JavaProject", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/JavaProject", "containsFile"));
        }
        return JavaProject.containsFile(contentRoot.getSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getResourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(@Nullable Collection<File> folderPaths, @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/JavaProject", "containsFile"));
        }
        if (folderPaths != null) {
            for (File path : folderPaths) {
                if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public File getJarFilePath() {
        Set<File> defaultArtifacts;
        Map<String, Set<File>> artifactsByConfiguration = this.getArtifactsByConfiguration();
        if (artifactsByConfiguration != null && !(defaultArtifacts = artifactsByConfiguration.get("default")).isEmpty()) {
            return (File)ContainerUtil.getFirstItem(defaultArtifacts);
        }
        return null;
    }

    @Nullable
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        Collection<JavaModuleDependency> collection = this.myJavaModuleDependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getJavaModuleDependencies"));
        }
        return collection;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        Collection<JarLibraryDependency> collection = this.myJarLibraryDependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/JavaProject", "getJarLibraryDependencies"));
        }
        return collection;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidProjectWithoutVariants() {
        return this.myAndroidProjectWithoutVariants;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }
}

