/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public final class GradleDslLiteralList
extends GradleDslElement {
    @NotNull
    private final List<GradleDslLiteral> myElements;
    @NotNull
    private final List<GradleDslLiteral> myToBeAddedElements;
    @NotNull
    private final List<GradleDslLiteral> myToBeRemovedElements;

    public GradleDslLiteralList(@Nullable GradleDslElement parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        super(parent, null, name);
        this.myElements = Lists.newArrayList();
        this.myToBeAddedElements = Lists.newArrayList();
        this.myToBeRemovedElements = Lists.newArrayList();
    }

    public GradleDslLiteralList(@NotNull GradleDslElement parent, @NotNull String name, @NotNull GrListOrMap list) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        super(parent, (GroovyPsiElement)list, name);
        this.myElements = Lists.newArrayList();
        this.myToBeAddedElements = Lists.newArrayList();
        this.myToBeRemovedElements = Lists.newArrayList();
        assert (!list.isMap());
        for (GrExpression exp : list.getInitializers()) {
            if (!(exp instanceof GrLiteral)) continue;
            this.myElements.add(new GradleDslLiteral(this, (GroovyPsiElement)list, name, (GrLiteral)exp));
        }
    }

    public GradleDslLiteralList(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull String name, GrLiteral ... literals) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        if (literals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literals", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "<init>"));
        }
        super(parent, psiElement, name);
        this.myElements = Lists.newArrayList();
        this.myToBeAddedElements = Lists.newArrayList();
        this.myToBeRemovedElements = Lists.newArrayList();
        for (GrLiteral literal : literals) {
            this.myElements.add(new GradleDslLiteral(this, psiElement, name, literal));
        }
    }

    void add(@NotNull GroovyPsiElement psiElement, @NotNull String name, GrLiteral ... literals) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "add"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "add"));
        }
        if (literals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literals", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "add"));
        }
        this.setPsiElement(psiElement);
        for (GrLiteral literal : literals) {
            this.myElements.add(new GradleDslLiteral(this, psiElement, name, literal));
        }
    }

    @NotNull
    public List<GradleDslLiteral> getElements() {
        if (this.myToBeAddedElements.isEmpty() && this.myToBeRemovedElements.isEmpty()) {
            ImmutableList immutableList = ImmutableList.copyOf(this.myElements);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "getElements"));
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myElements);
        result.addAll(this.myToBeAddedElements);
        for (GradleDslLiteral element : this.myToBeRemovedElements) {
            result.remove(element);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "getElements"));
        }
        return arrayList;
    }

    public void add(GradleDslLiteral ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "add"));
        }
        this.myToBeAddedElements.addAll(Arrays.asList(elements));
        this.setModified(true);
    }

    void add(@NotNull Object elementValue) {
        if (elementValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "add"));
        }
        GradleDslLiteral element = new GradleDslLiteral(this, this.myName);
        element.setValue(elementValue);
        this.myToBeAddedElements.add(element);
    }

    void remove(@NotNull Object elementValue) {
        if (elementValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "remove"));
        }
        for (GradleDslLiteral element : this.getElements()) {
            if (!elementValue.equals(element.getValue())) continue;
            this.myToBeRemovedElements.add(element);
            this.setModified(true);
            return;
        }
    }

    void replace(@NotNull Object oldElementValue, @NotNull Object newElementValue) {
        if (oldElementValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElementValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "replace"));
        }
        if (newElementValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "replace"));
        }
        for (GradleDslLiteral element : this.getElements()) {
            if (!oldElementValue.equals(element.getValue())) continue;
            element.setValue(newElementValue);
            return;
        }
    }

    @NotNull
    public <E> List<E> getValues(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslLiteral element : this.getElements()) {
            E value = element.getValue(clazz);
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "getValues"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GroovyPsiElement psiElement = super.create();
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrArgumentList) {
            if (((GrArgumentList)psiElement).getAllArguments().length == 1) {
                this.setPsiElement(null);
                psiElement = super.create();
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                this.setPsiElement((GroovyPsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.create();
        if (psiElement != null) {
            for (GradleDslLiteral element : this.myToBeAddedElements) {
                element.setPsiElement(psiElement);
                element.applyChanges();
                this.myElements.add(element);
            }
        }
        this.myToBeAddedElements.clear();
        for (GradleDslLiteral element : this.myToBeRemovedElements) {
            if (!this.myElements.remove(element)) continue;
            element.delete();
        }
        this.myToBeRemovedElements.clear();
        for (GradleDslLiteral element : this.myElements) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedElements.clear();
        this.myToBeRemovedElements.clear();
        for (GradleDslLiteral element : this.myElements) {
            if (!element.isModified()) continue;
            element.resetState();
        }
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteralList", "getChildren"));
        }
        return immutableList;
    }
}

