/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelUtil {
    public static final List<String> EXTRA_PROPERTIES_QUALIFIER = Arrays.asList("ext");
    private static final Logger LOG = Logger.getInstance(GradleEditorModelUtil.class);

    private GradleEditorModelUtil() {
    }

    @Nullable
    public static GradleEditorSourceBinding buildSourceBinding(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull Project project) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "buildSourceBinding"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "buildSourceBinding"));
        }
        return GradleEditorModelUtil.buildSourceBinding(new GradleEditorModelParseContext.Location(assignment.lValueLocation.file, assignment.assignmentRange), project);
    }

    @Nullable
    public static GradleEditorSourceBinding buildSourceBinding(@NotNull GradleEditorModelParseContext.Location location, @NotNull Project project) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "buildSourceBinding"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "buildSourceBinding"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(location.file);
        if (document == null) {
            LOG.warn(String.format("Can't obtain a document for file %s for processing location '%s'", location.file, location));
            return null;
        }
        RangeMarker rangeMarker = document.createRangeMarker(location.range);
        return new GradleEditorSourceBinding(project, location.file, rangeMarker);
    }

    public static boolean isVariable(@NotNull String targetText, @NotNull String variableName) {
        if (targetText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetText", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "isVariable"));
        }
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "isVariable"));
        }
        String targetTextToUse = GradleEditorModelUtil.unquote(targetText);
        if (targetTextToUse.equals(variableName) && targetText.equals(targetTextToUse)) {
            return true;
        }
        if (targetTextToUse.equals("$" + variableName)) {
            return true;
        }
        return targetTextToUse.equals("${" + variableName + "}");
    }

    @NotNull
    public static String unquote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "unquote"));
        }
        String string = StringUtil.unquoteString((String)StringUtil.unquoteString((String)s, (char)'\''), (char)'\"');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "unquote"));
        }
        return string;
    }

    @NotNull
    public static TextRange interestedRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "interestedRange"));
        }
        String text = GradleEditorModelUtil.unquote(element.getText());
        int shift = element.getText().indexOf(text);
        TextRange result = element.getTextRange();
        if (shift > 0) {
            result = TextRange.create((int)(result.getStartOffset() + shift), (int)(result.getStartOffset() + shift + text.length()));
        }
        TextRange textRange = result;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "interestedRange"));
        }
        return textRange;
    }

    @NotNull
    public static EntityInfo collectInfo(@NotNull Collection<GradleEditorModelParseContext.Variable> variables, @NotNull GradleEditorModelParseContext context, @Nullable AssignmentFilter filter) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "collectInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "collectInfo"));
        }
        HashSet processed = Sets.newHashSet();
        Stack<GradleEditorModelParseContext.Variable> toProcess = new Stack<GradleEditorModelParseContext.Variable>();
        toProcess.addAll(variables);
        ArrayList sourceBindings = Lists.newArrayList();
        String value = "";
        boolean skipValue = false;
        ArrayList assignments = Lists.newArrayList();
        while (!toProcess.isEmpty()) {
            GradleEditorModelParseContext.Variable dependency = (GradleEditorModelParseContext.Variable)toProcess.pop();
            if (!processed.add(dependency)) continue;
            assignments.clear();
            assignments.addAll(context.getAssignments(dependency));
            if (dependency.qualifier.isEmpty()) {
                assignments.addAll(context.getAssignments(new GradleEditorModelParseContext.Variable(dependency.name, EXTRA_PROPERTIES_QUALIFIER)));
            }
            Iterator iterator = assignments.iterator();
            while (iterator.hasNext()) {
                GradleEditorModelParseContext.Assignment a;
                GradleEditorModelParseContext.Assignment assignmentToUse = a = (GradleEditorModelParseContext.Assignment)iterator.next();
                if (filter != null) {
                    assignmentToUse = filter.check(a);
                }
                if (assignmentToUse == null) continue;
                Set dependencies = assignmentToUse.dependencies.keySet();
                if (assignmentToUse.value != null) {
                    sourceBindings.add(GradleEditorModelUtil.buildSourceBinding(assignmentToUse.value.location, context.getProject()));
                    if (value.isEmpty()) {
                        if (dependencies.size() > 1 || assignmentToUse.rValueString != null && dependencies.size() == 1 && !GradleEditorModelUtil.isVariable(assignmentToUse.rValueString, ((GradleEditorModelParseContext.Variable)dependencies.iterator().next()).name)) {
                            skipValue = true;
                            value = "";
                        }
                        if (!skipValue) {
                            value = assignmentToUse.value.value;
                        }
                    } else {
                        skipValue = true;
                        value = "";
                    }
                }
                toProcess.addAll(dependencies);
            }
        }
        EntityInfo entityInfo = new EntityInfo(sourceBindings, value);
        if (entityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "collectInfo"));
        }
        return entityInfo;
    }

    @Nullable
    public static String removeEntity(@NotNull GradleEditorEntity entity, boolean commit) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil", "removeEntity"));
        }
        GradleEditorSourceBinding location = entity.getEntityLocation();
        RangeMarker marker = location.getRangeMarker();
        if (!marker.isValid()) {
            return "source mapping is outdated for entity " + entity;
        }
        Document document = FileDocumentManager.getInstance().getDocument(location.getFile());
        if (document == null) {
            return "can't find a document for file " + location.getFile();
        }
        int startLine = document.getLineNumber(marker.getStartOffset());
        int endLine = document.getLineNumber(marker.getEndOffset());
        CharSequence text = document.getCharsSequence();
        String ws = " \t";
        int start = CharArrayUtil.shiftBackward((CharSequence)text, (int)document.getLineStartOffset(startLine), (int)(marker.getStartOffset() - 1), (String)ws);
        int end = CharArrayUtil.shiftForward((CharSequence)text, (int)marker.getEndOffset(), (int)document.getLineEndOffset(endLine), (String)ws);
        if (start == document.getLineStartOffset(startLine) && startLine > 0) {
            --start;
        } else if (end == document.getLineEndOffset(endLine) && endLine < document.getLineCount() - 1) {
            ++end;
        }
        document.deleteString(start, end);
        if (commit) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)location.getProject());
            psiDocumentManager.commitDocument(document);
        }
        return null;
    }

    public static class EntityInfo {
        @NotNull
        public final List<GradleEditorSourceBinding> sourceBindings;
        @NotNull
        public final String value;

        public EntityInfo(@NotNull List<GradleEditorSourceBinding> sourceBindings, @NotNull String value) {
            if (sourceBindings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBindings", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil$EntityInfo", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil$EntityInfo", "<init>"));
            }
            this.sourceBindings = sourceBindings;
            this.value = value;
        }
    }

    public static interface AssignmentFilter {
        @Nullable
        public GradleEditorModelParseContext.Assignment check(@NotNull GradleEditorModelParseContext.Assignment var1);
    }
}

