/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleInvokerOptions;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static final Logger LOG = Logger.getInstance(MakeBeforeRunTask.class);
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "<init>"));
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (AndroidStudioInitializer.isAndroidStudio() && MakeBeforeRunTaskProvider.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (runConfiguration instanceof AndroidRunConfigurationBase) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    private static boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "configurationTypeIsSupported"));
        }
        return runConfiguration instanceof AndroidRunConfigurationBase || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    public static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "isUnitTestConfiguration"));
        }
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList gradleTasks = Lists.newArrayList();
        for (Module module : moduleManager.getModules()) {
            GradleModel gradleModel;
            AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
            if (facet == null || (gradleModel = facet.getGradleModel()) == null) continue;
            gradleTasks.addAll(gradleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MakeBeforeRunTask task) {
        return task.isValid();
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        if (!Projects.requiresAndroidModel(this.myProject) || !Projects.isDirectGradleInvocationEnabled(this.myProject)) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        final AtomicBoolean success = new AtomicBoolean();
        try {
            String errorMsg;
            final Semaphore done = new Semaphore();
            done.down();
            final AtomicReference errorMsgRef = new AtomicReference();
            GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
            if (syncState.isSyncNeeded() != ThreeState.NO) {
                GradleProjectImporter.getInstance().syncProjectSynchronously(this.myProject, false, new GradleSyncListener.Adapter(){

                    @Override
                    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                        }
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                        }
                        errorMsgRef.set(errorMessage);
                    }
                });
            }
            if ((errorMsg = (String)errorMsgRef.get()) != null) {
                LOG.info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
                return false;
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            final GradleInvoker gradleInvoker = GradleInvoker.getInstance(this.myProject);
            final GradleInvoker.AfterGradleInvocationTask afterTask = new GradleInvoker.AfterGradleInvocationTask(){

                @Override
                public void execute(@NotNull GradleInvocationResult result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$2", "execute"));
                    }
                    success.set(result.isBuildSuccessful());
                    gradleInvoker.removeAfterGradleInvocationTask(this);
                    done.up();
                }
            };
            final GradleInvokerOptions options = GradleInvokerOptions.create(this.myProject, context, configuration, env, task.getGoal());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    gradleInvoker.addAfterGradleInvocationTask(afterTask);
                    gradleInvoker.executeTasks(options.tasks, options.buildMode, options.commandLineArguments);
                }
            });
            done.waitFor();
        }
        catch (Throwable t) {
            LOG.info("Unable to launch 'Gradle-aware Make' task", t);
            return false;
        }
        return success.get();
    }
}

