/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu;

import com.android.ddmlib.Client;
import com.android.tools.chartlib.TimelineComponent;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.GfxTraceCaptureAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.gpu.GpuSampler;
import com.android.tools.idea.monitor.gpu.ProfileStateListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GpuMonitorView
extends BaseMonitorView<GpuSampler>
implements ProfileStateListener {
    public static final int PRE_M_SAMPLE_FREQUENCY_MS = 33;
    private static final float PRE_M_TIMELINE_BUFFER_TIME = 0.0495f;
    private static final float PRE_M_TIMELINE_ABSOLUTE_MAX = 67.0f;
    public static final int POST_M_SAMPLE_FREQUENCY_MS = 200;
    private static final float POST_M_TIMELINE_BUFFER_TIME = 0.3f;
    private static final float POST_M_TIMELINE_ABSOLUTE_MAX = 67.0f;
    private static final float TIMELINE_INITIAL_MAX = 17.0f;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 3.0f;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final String NEEDS_NEWER_API_LABEL = "This device does not support the minimum API level (16) for GPU monitor.";
    private static final String NEEDS_PROFILING_ENABLED_LABEL = "GPU Profiling needs to be enabled in the device's developer options. <a href='https://developer.android.com/preview/testing/performance.html#timing-dump'>Learn more</a>.";
    @NotNull
    private final JPanel myPanel;
    private int myApiLevel;
    public static final int EVENT_LAUNCH = 1;
    public static final int EVENT_TRACING = 2;

    public GpuMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "<init>"));
        }
        super(project, deviceContext, new GpuSampler(200), 0.3f, 17.0f, 67.0f, 3.0f);
        this.myApiLevel = 23;
        ((GpuSampler)this.mySampler).myProfileStateListener = this;
        this.myPanel = new JPanel(new BorderLayout());
        this.addOverlayText(NEEDS_NEWER_API_LABEL, 4);
        this.addOverlayText(NEEDS_PROFILING_ENABLED_LABEL, 6);
        this.myApiLevel = ((GpuSampler)this.mySampler).getApiLevel();
        this.configureTimelineComponent(((GpuSampler)this.mySampler).getTimelineData());
        deviceContext.addListener(this, (Disposable)project);
        this.myPanel.setBackground(BACKGROUND_COLOR);
        this.setViewComponent(this.myPanel);
    }

    @Override
    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        if (GfxTraceEditor.isEnabled()) {
            group.add((AnAction)new Separator());
            group.add((AnAction)new GfxTraceCaptureAction.Listen(this));
            group.add((AnAction)new GfxTraceCaptureAction.Launch(this));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    @Override
    public void clientSelected(@Nullable Client client) {
        int newApiLevel;
        if (client != ((GpuSampler)this.mySampler).getClient()) {
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.setOverlayEnabled(NEEDS_PROFILING_ENABLED_LABEL, false);
        }
        super.clientSelected(client);
        if (client != null && (newApiLevel = ((GpuSampler)this.mySampler).getApiLevel()) != this.myApiLevel) {
            this.myApiLevel = newApiLevel;
            this.configureTimelineComponent(((GpuSampler)this.mySampler).getTimelineData());
        }
    }

    @Override
    protected boolean getPreferredPausedState() {
        return true;
    }

    @Override
    @NotNull
    public String getMonitorName() {
        if ("GpuMonitor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "getMonitorName"));
        }
        return "GpuMonitor";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("gpu usage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "getDescription"));
        }
        return "gpu usage";
    }

    private void configureTimelineComponent(@NotNull TimelineData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "configureTimelineComponent"));
        }
        if (this.myApiLevel >= 23) {
            this.myPanel.remove((Component)this.myTimelineComponent);
            this.myTimelineComponent = new TimelineComponent(data, this.myEvents, 0.3f, 17.0f, 67.0f, 3.0f);
            this.myTimelineComponent.configureUnits("ms");
            this.myTimelineComponent.configureStream(0, "VSync Delay", (Color)new JBColor(31853, 26972));
            this.myTimelineComponent.configureStream(1, "Input Handling", (Color)new JBColor(41618, 35195));
            this.myTimelineComponent.configureStream(2, "Animation", (Color)new JBColor(45729, 38536));
            this.myTimelineComponent.configureStream(3, "Measure/Layout", (Color)new JBColor(2999734, 2533018));
            this.myTimelineComponent.configureStream(4, "Draw", (Color)new JBColor(2601727, 2201331));
            this.myTimelineComponent.configureStream(5, "Sync", (Color)new JBColor(6154239, 5227511));
            this.myTimelineComponent.configureStream(6, "Command Issue", (Color)new JBColor(0xFF4F40, 16007990));
            this.myTimelineComponent.configureStream(7, "Swap Buffers", (Color)new JBColor(16757760, 16750592));
            this.myTimelineComponent.configureStream(8, "Misc Time", (Color)new JBColor(36735, 31083));
            this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.myPanel.add((Component)this.myTimelineComponent, "Center");
        } else if (this.myApiLevel >= 16) {
            this.myPanel.remove((Component)this.myTimelineComponent);
            this.myTimelineComponent = new TimelineComponent(data, this.myEvents, 0.0495f, 17.0f, 67.0f, 3.0f);
            if (this.myApiLevel >= 21) {
                this.myTimelineComponent.configureUnits("ms");
                this.myTimelineComponent.configureStream(0, "Draw", (Color)new JBColor(4815346, 4089548));
                this.myTimelineComponent.configureStream(1, "Prepare", (Color)new JBColor(11075839, 0x8F00FF));
                this.myTimelineComponent.configureStream(2, "Process", (Color)new JBColor(16728853, 14432530));
                this.myTimelineComponent.configureStream(3, "Execute", (Color)new JBColor(16757760, 15112192));
                this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            } else {
                this.myTimelineComponent.configureUnits("ms");
                this.myTimelineComponent.configureStream(0, "Draw", (Color)new JBColor(4815346, 4089548));
                this.myTimelineComponent.configureStream(1, "Process", (Color)new JBColor(16728853, 14432530));
                this.myTimelineComponent.configureStream(2, "Execute", (Color)new JBColor(16757760, 15112192));
                this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            }
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.myPanel.add((Component)this.myTimelineComponent, "Center");
        } else {
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, true);
        }
        this.myTimelineComponent.configureEvent(1, 0, AndroidIcons.Ddms.Threads, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), false);
        this.myTimelineComponent.configureEvent(2, 0, AndroidIcons.Ddms.StartMethodProfiling, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), true);
        this.myTimelineComponent.addReference(16.6f, (Color)JBColor.GREEN);
        this.myTimelineComponent.addReference(33.3f, (Color)JBColor.RED);
    }

    @Override
    public void notifyGpuProfileStateChanged(final @NotNull Client client, final boolean enabled) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/monitor/gpu/GpuMonitorView", "notifyGpuProfileStateChanged"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((GpuSampler)GpuMonitorView.this.mySampler).getClient() == client) {
                    GpuMonitorView.this.setOverlayEnabled(GpuMonitorView.NEEDS_PROFILING_ENABLED_LABEL, !enabled);
                    if (enabled) {
                        GpuMonitorView.this.configureTimelineComponent(((GpuSampler)GpuMonitorView.this.mySampler).getTimelineData());
                    } else {
                        ((GpuSampler)GpuMonitorView.this.mySampler).getTimelineData().clear();
                    }
                }
            }
        });
    }
}

