/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.npw.CreateModuleTemplate;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.ModuleTemplateProvider;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class AndroidModuleTemplatesProvider
implements ModuleTemplateProvider {
    @NotNull
    private static Collection<ModuleTemplate> getModuleTemplates(@NotNull TemplateMetadata metadata, @NotNull FormFactorUtils.FormFactor formFactor) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTemplates"));
        }
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTemplates"));
        }
        if (formFactor.equals(FormFactorUtils.FormFactor.MOBILE)) {
            CreateModuleTemplate androidApplication = new CreateModuleTemplate(metadata, formFactor, "Phone & Tablet Module", AndroidIcons.ModuleTemplates.Mobile);
            androidApplication.setCustomValue(WizardConstants.IS_LIBRARY_KEY, false);
            CreateModuleTemplate androidLibrary = new CreateModuleTemplate(metadata, formFactor, "Android Library", AndroidIcons.ModuleTemplates.Android);
            androidLibrary.setCustomValue(WizardConstants.IS_LIBRARY_KEY, true);
            ImmutableSet immutableSet = ImmutableSet.of((Object)androidApplication, (Object)androidLibrary);
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTemplates"));
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = ImmutableSet.of((Object)new CreateModuleTemplate(metadata, formFactor, metadata.getTitle(), AndroidModuleTemplatesProvider.getModuleTypeIcon(formFactor.getEnumValue())));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTemplates"));
        }
        return immutableSet;
    }

    private static Icon getModuleTypeIcon(@NotNull DeviceMenuAction.FormFactor enumValue) {
        if (enumValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumValue", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTypeIcon"));
        }
        switch (enumValue) {
            case CAR: {
                return AndroidIcons.ModuleTemplates.Car;
            }
            case GLASS: {
                return AndroidIcons.ModuleTemplates.Glass;
            }
            case MOBILE: {
                return AndroidIcons.ModuleTemplates.Mobile;
            }
            case TV: {
                return AndroidIcons.ModuleTemplates.Tv;
            }
            case WEAR: {
                return AndroidIcons.ModuleTemplates.Wear;
            }
        }
        throw new IllegalArgumentException(enumValue.name());
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        ArrayList moduleTemplates = Lists.newArrayList();
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            moduleTemplates.addAll(AndroidModuleTemplatesProvider.getModuleTemplates(metadata, formFactor));
        }
        Collections.sort(moduleTemplates, new Comparator<ModuleTemplate>(){

            @Override
            public int compare(ModuleTemplate t1, ModuleTemplate t2) {
                FormFactorUtils.FormFactor f1 = t1.getFormFactor();
                FormFactorUtils.FormFactor f2 = t2.getFormFactor();
                assert (f1 != null) : t1;
                assert (f2 != null) : t2;
                return f1.compareTo(f2);
            }
        });
        ArrayList arrayList = moduleTemplates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/AndroidModuleTemplatesProvider", "getModuleTemplates"));
        }
        return arrayList;
    }
}

