/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AssetRepository;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository {
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AssetRepositoryImpl", "<init>"));
        }
        this.myFacet = facet;
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(String path, int mode) throws IOException {
        List<IdeaSourceProvider> sourceProviders = IdeaSourceProvider.getAllIdeaSourceProviders(this.myFacet);
        for (int i = sourceProviders.size() - 1; i >= 0; --i) {
            for (VirtualFile assetDir : sourceProviders.get(i).getAssetsDirectories()) {
                VirtualFile asset = assetDir.findFileByRelativePath(path);
                if (asset == null) continue;
                return asset.getInputStream();
            }
        }
        return null;
    }
}

