/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidActivityLauncher
extends AndroidApplicationLauncher {
    private static final Logger LOG = Logger.getInstance(AndroidActivityLauncher.class);
    @NotNull
    private final ActivityLocator myActivityLocator;
    @NotNull
    private final String myActivityExtraFlags;

    public AndroidActivityLauncher(@NotNull ActivityLocator locator, @NotNull String activityExtraFlags) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "<init>"));
        }
        if (activityExtraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityExtraFlags", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "<init>"));
        }
        this.myActivityLocator = locator;
        this.myActivityExtraFlags = activityExtraFlags;
    }

    @Override
    public boolean isReadyForDebugging(@NotNull ClientData data, @Nullable ProcessHandler processHandler) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "isReadyForDebugging"));
        }
        ClientData.DebuggerStatus status = data.getDebuggerConnectionStatus();
        switch (status) {
            case ERROR: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debug port is busy\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debug port is busy");
                return false;
            }
            case ATTACHED: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debugger already attached\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debugger already attached");
                return false;
            }
            case WAITING: {
                return true;
            }
        }
        String msg = "Client not ready yet.";
        if (processHandler != null) {
            processHandler.notifyTextAvailable(msg + "\n", ProcessOutputTypes.STDOUT);
        }
        LOG.info(msg);
        return false;
    }

    @Override
    public AndroidApplicationLauncher.LaunchResult launch(@NotNull AndroidRunningState state, @NotNull IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        String activityName;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "launch"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "launch"));
        }
        ProcessHandler processHandler = state.getProcessHandler();
        try {
            activityName = this.myActivityLocator.getQualifiedActivityName(device);
        }
        catch (ActivityLocator.ActivityLocatorException e) {
            processHandler.notifyTextAvailable("Could not identify launch activity: " + e.getMessage(), ProcessOutputTypes.STDOUT);
            return AndroidApplicationLauncher.LaunchResult.NOTHING_TO_DO;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(state.getPackageName(), activityName);
        if (state.isStopped()) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        processHandler.notifyTextAvailable("Launching application: " + activityPath + ".\n", ProcessOutputTypes.STDOUT);
        String command = AndroidActivityLauncher.getStartActivityCommand(activityPath, this.getDebugFlags(state), this.myActivityExtraFlags);
        return this.executeCommand(command, state, device);
    }

    @NotNull
    static String getStartActivityCommand(@NotNull String activityPath, @NotNull String debugFlags, @NotNull String extraFlags) {
        if (activityPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityPath", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getStartActivityCommand"));
        }
        if (debugFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugFlags", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getStartActivityCommand"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getStartActivityCommand"));
        }
        String string = "am start " + debugFlags + " -n \"" + activityPath + "\" " + "-a android.intent.action.MAIN " + "-c android.intent.category.LAUNCHER" + (extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getStartActivityCommand"));
        }
        return string;
    }

    @NotNull
    static String getLauncherActivityPath(@NotNull String packageName, @NotNull String activityName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getLauncherActivityPath"));
        }
        if (activityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getLauncherActivityPath"));
        }
        String string = packageName + "/" + activityName.replace("$", "\\$");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/AndroidActivityLauncher", "getLauncherActivityPath"));
        }
        return string;
    }
}

