/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.Nullable;

public class FmGetAppManifestDirMethod
implements TemplateMethodModelEx {
    private static final String APP_NAME = "app";
    private static final String MOBILE_NAME = "mobile";
    private final Map<String, Object> myParamMap;

    public FmGetAppManifestDirMethod(Map<String, Object> paramMap) {
        this.myParamMap = paramMap;
    }

    public Object exec(List arguments) throws TemplateModelException {
        Module module = this.findAppModuleIfAny();
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        IdeaSourceProvider provider = facet.getMainIdeaSourceProvider();
        VirtualFile file = provider.getManifestFile();
        if (file == null) {
            return null;
        }
        return file.getParent().getCanonicalPath();
    }

    @Nullable
    private Module findAppModuleIfAny() {
        Project project;
        VirtualFile file;
        String modulePath = (String)this.myParamMap.get("projectOut");
        if (modulePath != null && (file = LocalFileSystem.getInstance().findFileByIoFile(new File(modulePath.replace('/', File.separatorChar)))) != null && (project = ProjectLocator.getInstance().guessProjectForFile(file)) != null) {
            ModuleManager manager = ModuleManager.getInstance((Project)project);
            Module module = manager.findModuleByName(APP_NAME);
            if (module != null) {
                return module;
            }
            return manager.findModuleByName(MOBILE_NAME);
        }
        return null;
    }
}

