/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class Parameter {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Parameter");
    private static final Set<String> typeValues = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final EnumSet<Constraint> TYPE_CONSTRAINTS = EnumSet.of(Constraint.ACTIVITY, new Constraint[]{Constraint.APILEVEL, Constraint.CLASS, Constraint.PACKAGE, Constraint.APP_PACKAGE, Constraint.MODULE, Constraint.LAYOUT, Constraint.DRAWABLE, Constraint.ID, Constraint.SOURCE_SET_FOLDER, Constraint.STRING});
    public final TemplateMetadata template;
    @NotNull
    public final Type type;
    @Nullable
    public final String id;
    @Nullable
    public final String name;
    @Nullable
    public final String initial;
    @Nullable
    public final String suggest;
    @Nullable
    public final String visibility;
    @Nullable
    public final String enabled;
    @Nullable
    public final String sourceUrl;
    @Nullable
    public final String help;
    @NotNull
    public final Element element;
    @NotNull
    public final EnumSet<Constraint> constraints;
    public String externalTypeName;

    Parameter(@NotNull TemplateMetadata template, @NotNull Element parameter) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/templates/Parameter", "<init>"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/templates/Parameter", "<init>"));
        }
        this.template = template;
        this.element = parameter;
        String typeName = parameter.getAttribute("type");
        assert (typeName != null && !typeName.isEmpty()) : "type";
        this.type = Type.get(typeName);
        this.id = parameter.getAttribute("id");
        this.initial = parameter.getAttribute("default");
        this.suggest = parameter.getAttribute("suggest");
        this.visibility = parameter.getAttribute("visibility");
        this.enabled = parameter.getAttribute("enabled");
        this.sourceUrl = this.type == Type.EXTERNAL ? parameter.getAttribute("href") : null;
        this.name = parameter.getAttribute("name");
        this.help = parameter.getAttribute("help");
        this.externalTypeName = this.type == Type.CUSTOM ? typeName : null;
        String constraintString = parameter.getAttribute("constraints");
        if (constraintString != null && !constraintString.isEmpty()) {
            EnumSet<Constraint> constraintSet = null;
            for (String s : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)constraintString)) {
                Constraint constraint = Constraint.get(s);
                if (constraintSet == null) {
                    constraintSet = EnumSet.of(constraint);
                    continue;
                }
                constraintSet = EnumSet.copyOf(constraintSet);
                constraintSet.add(constraint);
            }
            this.constraints = constraintSet;
        } else {
            this.constraints = EnumSet.noneOf(Constraint.class);
        }
    }

    public List<Element> getOptions() {
        return TemplateUtils.getChildren(this.element);
    }

    @Nullable
    public String validate(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable Object value, Set<Object> relatedValues) {
        switch (this.type) {
            case EXTERNAL: 
            case CUSTOM: 
            case STRING: {
                return this.getErrorMessageForStringType(project, module, provider, packageName, value.toString(), relatedValues);
            }
        }
        return null;
    }

    @Nullable
    protected String getErrorMessageForStringType(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        Collection<Constraint> violations = this.validateStringType(project, module, provider, packageName, value, relatedValues);
        if (violations.contains((Object)Constraint.NONEMPTY)) {
            return "Please specify " + this.name;
        }
        if (violations.contains((Object)Constraint.ACTIVITY)) {
            return this.name + " is not a valid activity name";
        }
        if (!violations.contains((Object)Constraint.APILEVEL)) {
            if (violations.contains((Object)Constraint.CLASS)) {
                return this.name + " is not a valid class name";
            }
            if (violations.contains((Object)Constraint.PACKAGE)) {
                return this.name + " is not a valid package name";
            }
            if (violations.contains((Object)Constraint.MODULE)) {
                return this.name + " is not a valid module name";
            }
            if (violations.contains((Object)Constraint.APP_PACKAGE) && value != null) {
                String message = AndroidUtils.validateAndroidPackageName(value);
                if (message != null) {
                    return message;
                }
            } else if (violations.contains((Object)Constraint.LAYOUT) && value != null) {
                String resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.LAYOUT).getErrorText(value);
                if (resourceNameError != null) {
                    return this.name + " is not a valid resource name. " + resourceNameError;
                }
            } else if (violations.contains((Object)Constraint.DRAWABLE)) {
                String resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.DRAWABLE).getErrorText(value);
                if (resourceNameError != null) {
                    return this.name + " is not a valid resource name. " + resourceNameError;
                }
            } else {
                String resourceNameError;
                if (violations.contains((Object)Constraint.ID)) {
                    return this.name + " is not a valid id.";
                }
                if (violations.contains((Object)Constraint.STRING)) {
                    String resourceNameError2 = ResourceNameValidator.create(false, ResourceFolderType.VALUES).getErrorText(value);
                    if (resourceNameError2 != null) {
                        return this.name + " is not a valid resource name. " + resourceNameError2;
                    }
                } else if (violations.contains((Object)Constraint.VALUES) && (resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.VALUES).getErrorText(value)) != null) {
                    return this.name + " is not a valid resource name. " + resourceNameError;
                }
            }
        }
        if (violations.contains((Object)Constraint.UNIQUE)) {
            return this.name + " must be unique";
        }
        if (violations.contains((Object)Constraint.EXISTS)) {
            return this.name + " must already exist";
        }
        return null;
    }

    @NotNull
    protected Collection<Constraint> validateStringType(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        String modulePath;
        AndroidFacet facet;
        String resourceNameError;
        GlobalSearchScope searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.EMPTY_SCOPE;
        HashSet violations = Sets.newHashSet();
        if (value == null || value.isEmpty()) {
            if (this.constraints.contains((Object)Constraint.NONEMPTY)) {
                violations.add(Constraint.NONEMPTY);
            }
            HashSet hashSet = violations;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Parameter", "validateStringType"));
            }
            return hashSet;
        }
        boolean exists = false;
        String fqName = (packageName != null && value.indexOf(46) == -1 ? packageName + "." : "") + value;
        if (this.constraints.contains((Object)Constraint.ACTIVITY)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(fqName)) {
                violations.add(Constraint.ACTIVITY);
            }
            if (project != null) {
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqName, searchScope);
                PsiClass activityClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", GlobalSearchScope.allScope((Project)project));
                boolean bl = exists = aClass != null && activityClass != null && aClass.isInheritor(activityClass, true);
            }
        }
        if (this.constraints.contains((Object)Constraint.APILEVEL)) {
            // empty if block
        }
        if (this.constraints.contains((Object)Constraint.CLASS)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(fqName)) {
                violations.add(Constraint.CLASS);
            }
            if (project != null) {
                exists = Parameter.existsClassFile(project, searchScope, provider, fqName);
            }
        }
        if (this.constraints.contains((Object)Constraint.PACKAGE)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(value)) {
                violations.add(Constraint.PACKAGE);
            }
            if (project != null) {
                exists = Parameter.existsPackage(project, searchScope, provider, value);
            }
        }
        if (this.constraints.contains((Object)Constraint.MODULE) && project != null) {
            boolean bl = exists = ModuleManager.getInstance((Project)project).findModuleByName(value) != null;
        }
        if (this.constraints.contains((Object)Constraint.APP_PACKAGE)) {
            String message = AndroidUtils.validateAndroidPackageName(value);
            if (message != null) {
                violations.add(Constraint.APP_PACKAGE);
            }
            if (project != null) {
                exists = Parameter.existsPackage(project, searchScope, provider, value);
            }
        }
        if (this.constraints.contains((Object)Constraint.LAYOUT)) {
            resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.LAYOUT).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.LAYOUT);
            }
            boolean bl = exists = provider != null ? Parameter.existsResourceFile(provider, module, ResourceFolderType.LAYOUT, ResourceType.LAYOUT, value) : Parameter.existsResourceFile(module, ResourceType.LAYOUT, value);
        }
        if (this.constraints.contains((Object)Constraint.DRAWABLE)) {
            resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.DRAWABLE).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.DRAWABLE);
            }
            boolean bl = exists = provider != null ? Parameter.existsResourceFile(provider, module, ResourceFolderType.DRAWABLE, ResourceType.DRAWABLE, value) : Parameter.existsResourceFile(module, ResourceType.DRAWABLE, value);
        }
        if (this.constraints.contains((Object)Constraint.ID)) {
            // empty if block
        }
        if (this.constraints.contains((Object)Constraint.VALUES)) {
            resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.VALUES).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.VALUES);
            }
            if (provider != null) {
                for (File resDir : provider.getResDirectories()) {
                    if (!Parameter.existsResourceFile(resDir, ResourceFolderType.VALUES, value)) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (this.constraints.contains((Object)Constraint.STRING) && (resourceNameError = ResourceNameValidator.create(false, ResourceFolderType.VALUES).getErrorText(value)) != null) {
            violations.add(Constraint.STRING);
        }
        if (this.constraints.contains((Object)Constraint.SOURCE_SET_FOLDER) && module != null && (facet = AndroidFacet.getInstance(module)) != null && (modulePath = AndroidRootUtil.getModuleDirPath(module)) != null) {
            File file = new File(FileUtil.toSystemDependentName((String)modulePath), value);
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            boolean bl = exists = !IdeaSourceProvider.getSourceProvidersForFile(facet, vFile, null).isEmpty();
        }
        if (relatedValues != null && relatedValues.contains(value)) {
            exists = true;
        }
        if (this.constraints.contains((Object)Constraint.UNIQUE) && exists) {
            violations.add(Constraint.UNIQUE);
        } else if (this.constraints.contains((Object)Constraint.EXISTS) && !exists) {
            violations.add(Constraint.EXISTS);
        }
        HashSet hashSet = violations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Parameter", "validateStringType"));
        }
        return hashSet;
    }

    public boolean uniquenessSatisfied(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        return !this.validateStringType(project, module, provider, packageName, value, relatedValues).contains((Object)Constraint.UNIQUE);
    }

    private static boolean isValidFullyQualifiedJavaIdentifier(String value) {
        return AndroidUtils.isValidJavaPackageName(value) && value.indexOf(46) != -1;
    }

    public static boolean existsResourceFile(@Nullable Module module, @NotNull ResourceType resourceType, @Nullable String name) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/templates/Parameter", "existsResourceFile"));
        }
        if (name == null || name.isEmpty() || module == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            AppResourceRepository repository = facet.getAppResources(true);
            return repository.hasResourceItem(resourceType, name);
        }
        return false;
    }

    public static boolean existsResourceFile(@Nullable SourceProvider sourceProvider, @Nullable Module module, @NotNull ResourceFolderType resourceFolderType, @NotNull ResourceType resourceType, @Nullable String name) {
        if (resourceFolderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFolderType", "com/android/tools/idea/templates/Parameter", "existsResourceFile"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/templates/Parameter", "existsResourceFile"));
        }
        if (name == null || name.isEmpty() || sourceProvider == null) {
            return false;
        }
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        for (File resDir : sourceProvider.getResDirectories()) {
            ResourceFolderRepository folderRepository;
            List resourceItemList;
            VirtualFile virtualResDir;
            if (!(facet != null ? (virtualResDir = VfsUtil.findFileByIoFile((File)resDir, (boolean)false)) != null && (resourceItemList = (folderRepository = ResourceFolderRegistry.get(facet, virtualResDir)).getResourceItem(resourceType, name)) != null && !resourceItemList.isEmpty() : Parameter.existsResourceFile(resDir, resourceFolderType, name))) continue;
            return true;
        }
        return false;
    }

    public static boolean existsResourceFile(File resDir, ResourceFolderType resourceType, String name) {
        File[] resTypes = resDir.listFiles();
        if (resTypes != null) {
            for (File resTypeDir : resTypes) {
                File[] files;
                if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
                for (File f : files) {
                    if (!Parameter.getNameWithoutExtensions(f).equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static String getNameWithoutExtensions(@NotNull File f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/templates/Parameter", "getNameWithoutExtensions"));
        }
        if (f.getName().indexOf(46) == -1) {
            String string = f.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Parameter", "getNameWithoutExtensions"));
            }
            return string;
        }
        String string = f.getName().substring(0, f.getName().indexOf(46));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Parameter", "getNameWithoutExtensions"));
        }
        return string;
    }

    public static boolean existsClassFile(@Nullable Project project, @NotNull GlobalSearchScope searchScope, @Nullable SourceProvider sourceProvider, @NotNull String fullyQualifiedClassName) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/android/tools/idea/templates/Parameter", "existsClassFile"));
        }
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullyQualifiedClassName", "com/android/tools/idea/templates/Parameter", "existsClassFile"));
        }
        if (project == null) {
            return false;
        }
        if (sourceProvider != null) {
            for (File javaDir : sourceProvider.getJavaDirectories()) {
                File classFile = new File(javaDir, fullyQualifiedClassName.replace('.', File.separatorChar) + ".java");
                if (!classFile.exists()) continue;
                return true;
            }
            return false;
        }
        if (searchScope != GlobalSearchScope.EMPTY_SCOPE) {
            return JavaPsiFacade.getInstance((Project)project).findClass(fullyQualifiedClassName, searchScope) != null;
        }
        return false;
    }

    public static boolean existsPackage(@Nullable Project project, @NotNull GlobalSearchScope searchScope, @Nullable SourceProvider sourceProvider, @NotNull String packageName) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/android/tools/idea/templates/Parameter", "existsPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/templates/Parameter", "existsPackage"));
        }
        if (project == null) {
            return false;
        }
        if (sourceProvider != null) {
            for (File javaDir : sourceProvider.getJavaDirectories()) {
                File classFile = new File(javaDir, packageName.replace('.', File.separatorChar));
                if (!classFile.exists() || !classFile.isDirectory()) continue;
                return true;
            }
            return false;
        }
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName) != null;
    }

    public boolean isRelated(Parameter p) {
        Sets.SetView types = Sets.intersection((Set)Sets.intersection(p.constraints, this.constraints), TYPE_CONSTRAINTS);
        return !types.isEmpty();
    }

    public String toString() {
        return "(parameter id: " + this.id + ")";
    }

    public static enum Constraint {
        UNIQUE,
        EXISTS,
        NONEMPTY,
        EMPTY,
        ACTIVITY,
        APILEVEL,
        CLASS,
        PACKAGE,
        APP_PACKAGE,
        MODULE,
        LAYOUT,
        DRAWABLE,
        VALUES,
        ID,
        SOURCE_SET_FOLDER,
        STRING;


        public static Constraint get(String name) {
            try {
                return Constraint.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected template constraint '" + name + "'");
                if (name.indexOf(44) != -1) {
                    LOG.error("Use | to separate constraints");
                } else {
                    LOG.error("Expected one of :");
                    for (Constraint s : Constraint.values()) {
                        LOG.error("  " + s.name().toLowerCase(Locale.US));
                    }
                }
                return NONEMPTY;
            }
        }
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        ENUM,
        SEPARATOR,
        EXTERNAL,
        CUSTOM;


        public static Type get(String name) {
            try {
                if (typeValues.isEmpty()) {
                    for (Type t : Type.values()) {
                        typeValues.add(t.name().toUpperCase(Locale.US));
                    }
                }
                String upperCaseName = name.toUpperCase(Locale.US);
                if (!typeValues.contains(upperCaseName)) {
                    return CUSTOM;
                }
                return Type.valueOf(upperCaseName);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected template type '" + name + "'");
                LOG.error("Expected one of :");
                for (Type s : Type.values()) {
                    LOG.error("  " + s.name().toLowerCase(Locale.US));
                }
                return STRING;
            }
        }
    }
}

