/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class FindReferencesRecipeExecutor
implements RecipeExecutor {
    private final RenderingContext myContext;

    public FindReferencesRecipeExecutor(@NotNull RenderingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "<init>"));
        }
        this.myContext = context;
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "copy"));
        }
        if (from.isDirectory()) {
            throw new RuntimeException("Directories not supported for Find References");
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "instantiate"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "instantiate"));
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "merge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "merge"));
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void mkDir(@NotNull File at) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "mkDir"));
        }
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "addFilesToOpen"));
        }
        this.myContext.getFilesToOpen().add(this.resolveTargetFile(file));
    }

    @Override
    public void addDependency(@NotNull String mavenUrl) {
        if (mavenUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenUrl", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "addDependency"));
        }
        this.myContext.getDependencies().add(mavenUrl);
    }

    @Override
    public void updateAndSyncGradle() {
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "pushFolder"));
        }
    }

    @Override
    public void popFolder() {
    }

    public void addSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "addSourceFile"));
        }
        this.myContext.getSourceFiles().add(this.resolveSourceFile(file));
    }

    public void addTargetFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "addTargetFile"));
        }
        this.myContext.getTargetFiles().add(this.resolveTargetFile(file));
    }

    private File resolveSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "resolveSourceFile"));
        }
        if (file.isAbsolute()) {
            return file;
        }
        try {
            return this.myContext.getLoader().getSourceFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File resolveTargetFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor", "resolveTargetFile"));
        }
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myContext.getOutputRoot(), file.getPath());
    }
}

