/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.parse.StringFileAdapter;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeInstruction;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="recipe")
public class Recipe
implements RecipeInstruction {
    @XmlElements(value={@XmlElement(name="copy", type=CopyInstruction.class), @XmlElement(name="instantiate", type=InstantiateInstruction.class), @XmlElement(name="merge", type=MergeInstruction.class), @XmlElement(name="mkdir", type=MkDirInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class), @XmlElement(name="open", type=OpenInstruction.class), @XmlElement(name="recipe", type=Recipe.class)})
    private List<RecipeInstruction> instructions = Lists.newArrayList();
    @XmlAttribute(name="folder")
    @Nullable
    private String myFolder;

    public static Recipe parse(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/android/tools/idea/templates/recipe/Recipe", "parse"));
        }
        Recipe recipe = Recipe.unmarshal(xmlReader);
        recipe.instructions.add(new UpdateAndSyncGradleInstruction());
        return recipe;
    }

    private static Recipe unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/android/tools/idea/templates/recipe/Recipe", "unmarshal"));
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Recipe.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (Recipe)unmarshaller.unmarshal(xmlReader);
    }

    @NotNull
    private static File cloneWithoutFreemarkerSuffix(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/Recipe", "cloneWithoutFreemarkerSuffix"));
        }
        File clone = new File(file.getPath());
        File file2 = TemplateUtils.stripSuffix(clone, ".ftl");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/Recipe", "cloneWithoutFreemarkerSuffix"));
        }
        return file2;
    }

    @Override
    public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe", "execute"));
        }
        if (this.myFolder == null) {
            this.executeInstructions(executor);
        } else {
            executor.pushFolder(this.myFolder);
            try {
                this.executeInstructions(executor);
            }
            finally {
                executor.popFolder();
            }
        }
    }

    private void executeInstructions(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe", "executeInstructions"));
        }
        for (RecipeInstruction instruction : this.instructions) {
            instruction.execute(executor);
        }
    }

    private static final class UpdateAndSyncGradleInstruction
    implements RecipeInstruction {
        private UpdateAndSyncGradleInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$UpdateAndSyncGradleInstruction", "execute"));
            }
            executor.updateAndSyncGradle();
        }
    }

    private static final class DependencyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;

        private DependencyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$DependencyInstruction", "execute"));
            }
            executor.addDependency(this.mavenUrl);
        }
    }

    private static final class OpenInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File file;

        private OpenInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$OpenInstruction", "execute"));
            }
            executor.addFilesToOpen(this.file);
        }
    }

    private static final class MkDirInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File at;

        private MkDirInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$MkDirInstruction", "execute"));
            }
            executor.mkDir(this.at);
        }
    }

    private static final class MergeInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private MergeInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$MergeInstruction", "execute"));
            }
            assert (this.to != null);
            executor.merge(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class InstantiateInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private InstantiateInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$InstantiateInstruction", "execute"));
            }
            assert (this.to != null);
            executor.instantiate(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class CopyInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private CopyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$CopyInstruction", "execute"));
            }
            assert (this.to != null);
            executor.copy(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }
}

