/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.designer.DesignerEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class BuildProjectListener
implements ProjectComponent {
    private final FileEditorManager myFileEditorManager;

    public BuildProjectListener(Project project, FileEditorManager fileEditorManager) {
        this.myFileEditorManager = fileEditorManager;
        AndroidProjectBuildNotifications.subscribe(project, new AndroidProjectBuildNotifications.AndroidProjectBuildListener(){

            @Override
            public void buildComplete(@NotNull AndroidProjectBuildNotifications.BuildContext context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/android/designer/designSurface/BuildProjectListener$1", "buildComplete"));
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildProjectListener.this.updateDesigners();
                    }
                });
            }
        });
    }

    private void updateDesigners() {
        for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
            DesignerEditor designerEditor;
            if (!(editor instanceof DesignerEditor) || !((designerEditor = (DesignerEditor)editor).getDesignerPanel() instanceof AndroidDesignerEditorPanel)) continue;
            AndroidDesignerEditorPanel panel = (AndroidDesignerEditorPanel)designerEditor.getDesignerPanel();
            panel.buildProject();
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("BuildProjectListener" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/BuildProjectListener", "getComponentName"));
        }
        return "BuildProjectListener";
    }
}

