/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.GuidelinePainter;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.android.designer.model.layout.relative.MultiLineTooltipManager;
import com.intellij.android.designer.model.layout.relative.ResizeHandler;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class RelativeLayoutResizeOperation
implements EditOperation {
    public static final String TYPE = "relative_resize";
    private final OperationContext myContext;
    private RadViewComponent myComponent;
    private RadViewComponent myContainer;
    private GuidelinePainter myFeedback;
    private ResizeHandler myResizeHandler;
    private MultiLineTooltipManager myTooltip;

    public RelativeLayoutResizeOperation(OperationContext context) {
        this.myContext = context;
    }

    public void setComponent(RadComponent component) {
        this.myComponent = (RadViewComponent)component;
        this.myContainer = (RadViewComponent)this.myComponent.getParent();
    }

    public void setComponents(List<RadComponent> components) {
        assert (components.size() == 1) : components;
        this.myComponent = (RadViewComponent)components.get(0);
        this.myContainer = (RadViewComponent)this.myComponent.getParent();
    }

    public void showFeedback() {
        if (this.myFeedback == null) {
            SegmentType horizontalEdgeType = null;
            SegmentType verticalEdgeType = null;
            int direction = this.myContext.getResizeDirection();
            if ((direction & 1) != 0) {
                horizontalEdgeType = SegmentType.TOP;
            }
            if ((direction & 2) != 0) {
                horizontalEdgeType = SegmentType.BOTTOM;
            }
            if ((direction & 4) != 0) {
                verticalEdgeType = SegmentType.LEFT;
            }
            if ((direction & 8) != 0) {
                verticalEdgeType = SegmentType.RIGHT;
            }
            this.myResizeHandler = new ResizeHandler(this.myContainer, this.myComponent, this.myContext, horizontalEdgeType, verticalEdgeType);
            this.myFeedback = new GuidelinePainter(this.myResizeHandler);
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.add((Component)this.myFeedback);
            this.myFeedback.setBounds(0, 0, layer.getWidth(), layer.getHeight());
            this.myTooltip = new MultiLineTooltipManager(layer, 4);
        }
        Rectangle bounds = this.myContext.getTransformedRectangle(this.myComponent.getBounds((Component)this.myContext.getArea().getFeedbackLayer()));
        bounds.width = Math.max(bounds.width, 0);
        bounds.height = Math.max(bounds.height, 0);
        this.myResizeHandler.updateResize(this.myComponent, bounds, this.myContext.getModifiers());
        this.myFeedback.repaint();
        this.describeMatch(this.myResizeHandler.getCurrentLeftMatch(), 0, this.myResizeHandler.getLeftMarginDp(), "layout_marginLeft");
        this.describeMatch(this.myResizeHandler.getCurrentRightMatch(), 1, this.myResizeHandler.getRightMarginDp(), "layout_marginRight");
        this.describeMatch(this.myResizeHandler.getCurrentTopMatch(), 2, this.myResizeHandler.getTopMarginDp(), "layout_marginTop");
        this.describeMatch(this.myResizeHandler.getCurrentBottomMatch(), 3, this.myResizeHandler.getBottomMarginDp(), "layout_marginBottom");
        Point location = this.myContext.getLocation();
        this.myTooltip.update(this.myContainer, location);
    }

    private void describeMatch(Match m, int line, int margin, String marginAttribute) {
        if (m == null) {
            this.myTooltip.setVisible(line, false);
            return;
        }
        this.myTooltip.setVisible(line, true);
        TextFeedback feedback = this.myTooltip.getFeedback(line);
        m.describe(feedback, margin, marginAttribute);
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)this.myFeedback);
            this.myTooltip.dispose();
            this.myFeedback = null;
            this.myTooltip = null;
            layer.repaint();
        }
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                RelativeLayoutResizeOperation.this.myResizeHandler.removeCycles();
                RelativeLayoutResizeOperation.this.myResizeHandler.applyConstraints(RelativeLayoutResizeOperation.this.myComponent);
            }
        });
    }

    public static void addResizePoints(ResizeSelectionDecorator decorator) {
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 5, TYPE, "Change layout:width x layout:height, top x left alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 1, TYPE, "Change layout:height, top alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 9, TYPE, "Change layout:width x layout:height, top x right alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 8, TYPE, "Change layout:width, right alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 10, TYPE, "Change layout:width x layout:height, bottom x right alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 2, TYPE, "Change layout:height, bottom alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 6, TYPE, "Change layout:width x layout:height, bottom x left alignment"));
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.SELECTION, 4, TYPE, "Change layout:width, left alignment"));
    }
}

