/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.AndroidIcons;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFileTemplateProvider
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String REMOTE_INTERFACE_TEMPLATE = "Remote_Interface.aidl";
    @NonNls
    public static final String ANDROID_MANIFEST_TEMPLATE = "AndroidManifest.xml";
    @NonNls
    public static final String VALUE_RESOURCE_FILE_TEMPLATE = "valueResourceFile.xml";
    @NonNls
    public static final String RESOURCE_FILE_TEMPLATE = "resourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_FILE_TEMPLATE = "layoutResourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE = "layoutResourceFile_vertical.xml";
    @NonNls
    public static final String ACTIVITY = "Activity.java";
    @NonNls
    public static final String FRAGMENT = "Fragment.java";
    @NonNls
    public static final String APPLICATION = "Application.java";
    @NonNls
    public static final String SERVICE = "Service.java";
    @NonNls
    public static final String BROADCAST_RECEIVER = "Broadcast_Receiver.java";
    @NonNls
    public static final String DEFAULT_PROPERTIES_TEMPLATE = "default.properties";

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor("Android", AndroidIcons.Android);
        group.addTemplate(new FileTemplateDescriptor(ANDROID_MANIFEST_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(VALUE_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(ACTIVITY, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(FRAGMENT, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(APPLICATION, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(SERVICE, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(BROADCAST_RECEIVER, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(REMOTE_INTERFACE_TEMPLATE, AidlFileType.INSTANCE.getIcon()));
        return group;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName, @NotNull Properties properties) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        rootDir.refresh(false, false);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(rootDir);
        if (directory != null) {
            return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, properties);
        }
        return null;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        return AndroidFileTemplateProvider.createFromTemplate(project, rootDir, templateName, fileName, FileTemplateManager.getInstance((Project)project).getDefaultProperties());
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory, Properties properties) throws Exception {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)directory.getProject());
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)directory);
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory) throws Exception {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/AndroidFileTemplateProvider", "createFromTemplate"));
        }
        return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties());
    }

    @NotNull
    public static String getFileNameByNewElementName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/AndroidFileTemplateProvider", "getFileNameByNewElementName"));
        }
        if (!FileUtilRt.extensionEquals((String)name, (String)"xml")) {
            name = name + ".xml";
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidFileTemplateProvider", "getFileNameByNewElementName"));
        }
        return string;
    }
}

