/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.switchtoif.ReplaceSwitchWithIfIntention;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidNonConstantResIdsInSwitchInspection
extends LocalInspectionTool {
    private final ReplaceSwitchWithIfIntention myBaseIntention = new ReplaceSwitchWithIfIntention();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidNonConstantResIdsInSwitch" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection", "getShortName"));
        }
        return "AndroidNonConstantResIdsInSwitch";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)statement);
                if (facet == null || !facet.isLibraryProject()) {
                    return;
                }
                PsiExpression caseValue = statement.getCaseValue();
                if (!(caseValue instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
                if (switchStatement == null || !ReplaceSwitchWithIfIntention.canProcess((PsiSwitchStatement)switchStatement)) {
                    return;
                }
                PsiElement resolvedElement = ((PsiReferenceExpression)caseValue).resolve();
                if (resolvedElement == null || !(resolvedElement instanceof PsiField)) {
                    return;
                }
                PsiField resolvedField = (PsiField)resolvedElement;
                if (!AndroidResourceUtil.isResourceField(resolvedField)) {
                    return;
                }
                PsiModifierList modifierList = resolvedField.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("final")) {
                    holder.registerProblem((PsiElement)caseValue, AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.message", new Object[0]), new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public String getQuickFixName() {
        return this.myBaseIntention.getText();
    }

    private class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = AndroidNonConstantResIdsInSwitchInspection.this.getQuickFixName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchStatement.class);
            if (switchStatement == null) {
                return;
            }
            ConvertSwitchToIfIntention.doProcessIntention((PsiSwitchStatement)switchStatement);
        }
    }
}

