/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.inspections.lint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.lint.IntellijLintRequest;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidLintGlobalInspectionContext
implements GlobalInspectionContextExtension<AndroidLintGlobalInspectionContext> {
    static final Key<AndroidLintGlobalInspectionContext> ID = Key.create((String)"AndroidLintGlobalInspectionContext");
    private Map<Issue, Map<File, List<ProblemData>>> myResults;

    AndroidLintGlobalInspectionContext() {
    }

    @NotNull
    public Key<AndroidLintGlobalInspectionContext> getID() {
        Key<AndroidLintGlobalInspectionContext> key = ID;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "getID"));
        }
        return key;
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        if (globalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalTools", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "performPreRunActivities"));
        }
        if (localTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTools", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "performPreRunActivities"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "performPreRunActivities"));
        }
        Project project = context.getProject();
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return;
        }
        List<Issue> issues = AndroidLintExternalAnnotator.getIssuesFromInspections(project, null);
        if (issues.size() == 0) {
            return;
        }
        HashMap problemMap = new HashMap();
        AnalysisScope scope = context.getRefManager().getScope();
        if (scope == null) {
            return;
        }
        IntellijLintClient client = IntellijLintClient.forBatch(project, (Map<Issue, Map<File, List<ProblemData>>>)problemMap, scope, issues);
        LintDriver lint = new LintDriver((IssueRegistry)new IntellijLintIssueRegistry(), (LintClient)client);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ProgressWrapper.unwrap((ProgressIndicator)indicator).setText("Running Android Lint");
        }
        EnumSet lintScope = EnumSet.copyOf(Scope.ALL);
        lintScope.remove(Scope.CLASS_FILE);
        lintScope.remove(Scope.ALL_CLASS_FILES);
        lintScope.remove(Scope.JAVA_LIBRARIES);
        ArrayList files = null;
        final ArrayList modules = Lists.newArrayList();
        int scopeType = scope.getScopeType();
        switch (scopeType) {
            case 4: {
                ModuleWithDependenciesScope s;
                Object searchScope = scope.toSearchScope();
                if (!(searchScope instanceof ModuleWithDependenciesScope) || (s = (ModuleWithDependenciesScope)searchScope).isSearchInLibraries()) break;
                modules.add(s.getModule());
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                files = Lists.newArrayList();
                Object searchScope = scope.toSearchScope();
                if (searchScope instanceof LocalSearchScope) {
                    LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
                    final PsiElement[] elements = localSearchScope.getScope();
                    final ArrayList finalFiles = files;
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            for (PsiElement element : elements) {
                                VirtualFile virtualFile;
                                if (!(element instanceof PsiFile)) continue;
                                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                                if (module != null && !modules.contains(module)) {
                                    modules.add(module);
                                }
                                if ((virtualFile = ((PsiFile)element).getVirtualFile()) == null) continue;
                                finalFiles.add(virtualFile);
                            }
                        }
                    });
                } else {
                    final ArrayList finalList = files;
                    scope.accept(new PsiElementVisitor(){

                        public void visitFile(PsiFile file) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile != null) {
                                finalList.add(virtualFile);
                            }
                        }
                    });
                }
                if (files.isEmpty()) {
                    files = null;
                    break;
                }
                lintScope = null;
                break;
            }
            case 1: {
                modules.addAll(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                Logger.getInstance(this.getClass()).warn("Unexpected inspection scope " + scope + ", " + scopeType);
            }
        }
        if (modules.isEmpty()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!scope.containsModule(module)) continue;
                modules.add(module);
            }
            if (modules.isEmpty() && files != null) {
                for (VirtualFile file : files) {
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                    if (module == null || modules.contains(module)) continue;
                    modules.add(module);
                }
            }
            if (modules.isEmpty()) {
                AnalysisScope narrowed = scope.getNarrowedComplementaryScope(project);
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (!narrowed.containsModule(module)) continue;
                    modules.add(module);
                }
            }
        }
        IntellijLintRequest request = new IntellijLintRequest(client, project, files, modules, false);
        request.setScope(lintScope);
        lint.analyze((LintRequest)request);
        this.myResults = problemMap;
    }

    @Nullable
    public Map<Issue, Map<File, List<ProblemData>>> getResults() {
        return this.myResults;
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper> inspections, @NotNull GlobalInspectionContext context) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "performPostRunActivities"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext", "performPostRunActivities"));
        }
    }

    public void cleanup() {
    }
}

