/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.CompilationUnit;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.annotations.NonNls;

public class IntellijApiDetector
extends ApiDetector {
    static final Implementation IMPLEMENTATION = new Implementation(IntellijApiDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE});
    @NonNls
    private static final String TARGET_API_FQCN = "android.annotation.TargetApi";
    private static final String SDK_INT = "SDK_INT";

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(CompilationUnit.class);
    }

    public AstVisitor createJavaVisitor(final JavaContext context) {
        return new ForwardingAstVisitor(){

            public boolean visitCompilationUnit(CompilationUnit node) {
                IntellijApiDetector.this.check(context);
                return true;
            }
        };
    }

    private void check(final JavaContext context) {
        if (this.mApiDatabase == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
                if (!(psiFile instanceof PsiJavaFile)) {
                    return;
                }
                PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                for (PsiClass clz : javaFile.getClasses()) {
                    ApiCheckVisitor visitor = new ApiCheckVisitor((Context)context, clz, psiFile);
                    javaFile.accept((PsiElementVisitor)visitor);
                }
            }
        });
    }

    private static int getTargetApi(PsiElement e, PsiElement file) {
        for (PsiElement element = e; element != null && element != file; element = element.getParent()) {
            if (!(element instanceof PsiModifierListOwner)) continue;
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            PsiModifierList modifierList = owner.getModifierList();
            PsiAnnotation annotation = null;
            if (modifierList != null) {
                annotation = modifierList.findAnnotation(TARGET_API_FQCN);
            }
            if (annotation == null) continue;
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value = literal.getValue();
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (!(value instanceof String)) continue;
                    return IntellijApiDetector.codeNameToApi((String)value);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value = literal.getValue();
                        if (value instanceof Integer) {
                            return (Integer)value;
                        }
                        if (!(value instanceof String)) continue;
                        return IntellijApiDetector.codeNameToApi((String)value);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String fqcn = ((PsiReferenceExpression)v).getQualifiedName();
                    return IntellijApiDetector.codeNameToApi(fqcn);
                }
                return IntellijApiDetector.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    private static int codeNameToApi(String text) {
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            text = text.substring(dotIndex + 1);
        }
        return SdkVersionInfo.getApiByBuildCode((String)text, (boolean)true);
    }

    private static boolean isPrecededByVersionCheckExit(PsiElement element, int api) {
        PsiStatement prev;
        Object current = PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (current != null) {
            prev = IntellijApiDetector.getPreviousStatement(current);
            current = prev == null ? PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class}) : prev;
        }
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                Boolean level;
                PsiIfStatement ifStatement = (PsiIfStatement)current;
                PsiStatement thenBranch = ifStatement.getThenBranch();
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (thenBranch != null && (level = IntellijApiDetector.isVersionCheckConditional(api, (PsiElement)thenBranch, ifStatement)) != null && IntellijApiDetector.isUnconditionalReturn(thenBranch)) {
                    return true;
                }
                if (elseBranch != null && (level = IntellijApiDetector.isVersionCheckConditional(api, (PsiElement)elseBranch, ifStatement)) != null && IntellijApiDetector.isUnconditionalReturn(elseBranch)) {
                    return true;
                }
            }
            if ((prev = IntellijApiDetector.getPreviousStatement(current)) == null) {
                if ((current = PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) != null) continue;
                return false;
            }
            current = prev;
        }
        return false;
    }

    private static boolean isUnconditionalReturn(PsiStatement statement) {
        PsiBlockStatement blockStatement;
        PsiCodeBlock block;
        PsiStatement[] statements;
        if (statement instanceof PsiBlockStatement && (statements = (block = (blockStatement = (PsiBlockStatement)statement).getCodeBlock()).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            return true;
        }
        return statement instanceof PsiReturnStatement;
    }

    public static PsiStatement getPreviousStatement(PsiElement element) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        return prevStatement instanceof PsiStatement ? (PsiStatement)prevStatement : null;
    }

    private static boolean isWithinVersionCheckConditional(PsiElement element, int api) {
        PsiElement prev = element;
        for (PsiElement current = element.getParent(); current != null; current = current.getParent()) {
            if (current instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)current;
                Boolean isConditional = IntellijApiDetector.isVersionCheckConditional(api, prev, ifStatement);
                if (isConditional != null) {
                    return isConditional;
                }
            } else {
                if (current instanceof PsiPolyadicExpression && IntellijApiDetector.isAndedWithConditional(current, api, prev)) {
                    return true;
                }
                if (current instanceof PsiMethod || current instanceof PsiFile) {
                    return false;
                }
            }
            prev = current;
        }
        return false;
    }

    private static Boolean isVersionCheckConditional(int api, PsiElement prev, PsiIfStatement ifStatement) {
        Boolean isConditional;
        PsiReturnStatement returnStatement;
        PsiExpression returnValue;
        PsiStatement statement;
        PsiStatement[] statements;
        PsiCodeBlock body;
        PsiMethodCallExpression call;
        PsiMethod method;
        PsiExpression condition = ifStatement.getCondition();
        if (condition != prev && condition instanceof PsiBinaryExpression) {
            Boolean isConditional2 = IntellijApiDetector.isVersionCheckConditional(api, prev, ifStatement, (PsiBinaryExpression)condition);
            if (isConditional2 != null) {
                return isConditional2;
            }
        } else if (condition instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression ppe = (PsiPolyadicExpression)condition;
            if (ppe.getOperationTokenType() == JavaTokenType.ANDAND && prev == ifStatement.getThenBranch() && IntellijApiDetector.isAndedWithConditional((PsiElement)ppe, api, prev)) {
                return true;
            }
        } else if (condition instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)condition).resolveMethod()) != null && (body = method.getBody()) != null && (statements = body.getStatements()).length == 1 && (statement = statements[0]) instanceof PsiReturnStatement && (returnValue = (returnStatement = (PsiReturnStatement)statement).getReturnValue()) instanceof PsiBinaryExpression && (isConditional = IntellijApiDetector.isVersionCheckConditional(api, null, null, (PsiBinaryExpression)returnValue)) != null) {
            return isConditional;
        }
        return null;
    }

    private static Boolean isVersionCheckConditional(int api, PsiElement prev, PsiIfStatement ifStatement, PsiBinaryExpression binary) {
        IElementType tokenType = binary.getOperationTokenType();
        if (tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.LT || tokenType == JavaTokenType.EQEQ) {
            PsiReferenceExpression ref;
            PsiExpression left = binary.getLOperand();
            if (left instanceof PsiReferenceExpression && SDK_INT.equals((ref = (PsiReferenceExpression)left).getReferenceName())) {
                PsiLiteralExpression lit;
                Object value;
                PsiExpression right = binary.getROperand();
                int level = -1;
                if (right instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref2 = (PsiReferenceExpression)right;
                    String codeName = ref2.getReferenceName();
                    if (codeName == null) {
                        return false;
                    }
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof PsiLiteralExpression && (value = (lit = (PsiLiteralExpression)right).getValue()) instanceof Integer) {
                    level = (Integer)value;
                }
                if (level != -1) {
                    boolean fromElse;
                    boolean fromThen = ifStatement == null || prev == ifStatement.getThenBranch();
                    boolean bl = fromElse = ifStatement != null && prev == ifStatement.getElseBranch();
                    assert (fromThen == !fromElse);
                    if (tokenType == JavaTokenType.GE) {
                        return level >= api && fromThen;
                    }
                    if (tokenType == JavaTokenType.GT) {
                        return level >= api - 1 && fromThen;
                    }
                    if (tokenType == JavaTokenType.LE) {
                        return level >= api - 1 && fromElse;
                    }
                    if (tokenType == JavaTokenType.LT) {
                        return level >= api && fromElse;
                    }
                    if (tokenType == JavaTokenType.EQEQ) {
                        return level >= api && fromThen;
                    }
                    assert (false) : tokenType;
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND && ifStatement != null && prev == ifStatement.getThenBranch() && IntellijApiDetector.isAndedWithConditional((PsiElement)ifStatement.getCondition(), api, prev)) {
            return true;
        }
        return null;
    }

    private static boolean isAndedWithConditional(PsiElement element, int api, PsiElement before) {
        PsiPolyadicExpression ppe;
        if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression inner = (PsiBinaryExpression)element;
            if (inner.getOperationTokenType() == JavaTokenType.ANDAND) {
                return IntellijApiDetector.isAndedWithConditional((PsiElement)inner.getLOperand(), api, before) || inner.getROperand() != before && IntellijApiDetector.isAndedWithConditional((PsiElement)inner.getROperand(), api, before);
            }
            if (inner.getLOperand() instanceof PsiReferenceExpression && SDK_INT.equals(((PsiReferenceExpression)inner.getLOperand()).getReferenceName())) {
                PsiLiteralExpression lit;
                Object value;
                int level = -1;
                IElementType tokenType = inner.getOperationTokenType();
                PsiExpression right = inner.getROperand();
                if (right instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref2 = (PsiReferenceExpression)right;
                    String codeName = ref2.getReferenceName();
                    if (codeName == null) {
                        return false;
                    }
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof PsiLiteralExpression && (value = (lit = (PsiLiteralExpression)right).getValue()) instanceof Integer) {
                    level = (Integer)value;
                }
                if (level != -1) {
                    if (tokenType == JavaTokenType.GE) {
                        return level >= api;
                    }
                    if (tokenType == JavaTokenType.GT) {
                        return level >= api - 1;
                    }
                    if (tokenType == JavaTokenType.EQEQ) {
                        return level >= api;
                    }
                }
            }
        } else if (element instanceof PsiPolyadicExpression && (ppe = (PsiPolyadicExpression)element).getOperationTokenType() == JavaTokenType.ANDAND) {
            for (PsiExpression operand : ppe.getOperands()) {
                if (operand == before) break;
                if (!IntellijApiDetector.isAndedWithConditional((PsiElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private class ApiCheckVisitor
    extends JavaRecursiveElementVisitor {
        private final Context myContext;
        private boolean mySeenSuppress;
        private boolean mySeenTargetApi;
        private final PsiClass myClass;
        private final PsiFile myFile;
        private final boolean myCheckAccess;
        private boolean myCheckOverride;
        private String myFrameworkParent;

        public ApiCheckVisitor(Context context, PsiClass clz, PsiFile file) {
            this.myContext = context;
            this.myClass = clz;
            this.myFile = file;
            this.myCheckAccess = context.isEnabled(ApiDetector.UNSUPPORTED) || context.isEnabled(ApiDetector.INLINED);
            boolean bl = this.myCheckOverride = context.isEnabled(ApiDetector.OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
            if (this.myCheckOverride) {
                this.myFrameworkParent = null;
                for (PsiClass superClass = this.myClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                    String fqcn = superClass.getQualifiedName();
                    if (fqcn == null) {
                        this.myCheckOverride = false;
                        continue;
                    }
                    if (!fqcn.startsWith("android.") && !fqcn.startsWith("java.") && !fqcn.startsWith("javax.")) continue;
                    if (fqcn.equals("java.lang.Object")) break;
                    this.myFrameworkParent = ClassContext.getInternalName((String)fqcn);
                    break;
                }
                if (this.myFrameworkParent == null) {
                    this.myCheckOverride = false;
                }
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String fqcn = annotation.getQualifiedName();
            if (IntellijApiDetector.TARGET_API_FQCN.equals(fqcn)) {
                this.mySeenTargetApi = true;
            } else if ("android.annotation.SuppressLint".equals(fqcn) || "java.lang.SuppressWarnings".equals(fqcn)) {
                this.mySeenSuppress = true;
            }
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!this.myCheckOverride) {
                return;
            }
            int buildSdk = this.myContext.getMainProject().getBuildSdk();
            String name = method.getName();
            assert (this.myFrameworkParent != null);
            String desc = IntellijLintUtils.getInternalDescription(method, false, false);
            if (desc == null) {
                return;
            }
            int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(this.myFrameworkParent, name, desc);
            if (api > buildSdk && buildSdk != -1) {
                String fqcn;
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)method, this.myFile, ApiDetector.OVERRIDE)) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    String className = containingClass.getName();
                    String fullClassName = containingClass.getQualifiedName();
                    if (fullClassName != null) {
                        className = fullClassName;
                    }
                    fqcn = className + '#' + name;
                } else {
                    fqcn = name;
                }
                String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api, buildSdk, fqcn);
                PsiIdentifier locationNode = method.getNameIdentifier();
                if (locationNode == null) {
                    locationNode = method;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)locationNode);
                this.myContext.report(ApiDetector.OVERRIDE, location, message);
            }
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (!this.myCheckAccess) {
                return;
            }
            for (PsiClassType type : aClass.getSuperTypes()) {
                Location location;
                int target;
                int minSdk;
                int api;
                String signature = IntellijLintUtils.getInternalName(type);
                if (signature == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)aClass, (PsiElement)this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)aClass, this.myFile, ApiDetector.UNSUPPORTED)) continue;
                if (type instanceof PsiClassReferenceType) {
                    PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)type).getReference();
                    PsiElement element = reference.getElement();
                    if (IntellijApiDetector.isWithinVersionCheckConditional(element, api) || IntellijApiDetector.isPrecededByVersionCheckExit(element, api)) continue;
                    location = IntellijLintUtils.getLocation(this.myContext.file, element);
                } else {
                    location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)aClass);
                }
                String fqcn = type.getClassName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiReference reference = expression.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved != null && resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = field.getName();
                int api = IntellijApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)expression);
                String fqcn = containingClass.getQualifiedName();
                String message = String.format("Field requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + name);
                Issue issue = ApiDetector.UNSUPPORTED;
                PsiType type = field.getType();
                if (PsiType.INT.equals((Object)type) || PsiType.CHAR.equals((Object)type) || PsiType.BOOLEAN.equals((Object)type) || PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.BYTE.equals((Object)type) || type.equalsToText("java.lang.String")) {
                    issue = ApiDetector.INLINED;
                    if (this.isBenignConstantUsage((PsiElement)expression, name, owner)) {
                        return;
                    }
                }
                this.myContext.report(issue, location, message);
            }
        }

        public void visitTryStatement(PsiTryStatement statement) {
            super.visitTryStatement(statement);
            PsiResourceList resourceList = statement.getResourceList();
            if (resourceList != null) {
                int api = 19;
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)statement, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)resourceList);
                String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                int target;
                int minSdk;
                int api;
                String signature;
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                PsiType type = typeElement.getType();
                PsiClass resolved = null;
                PsiParameter reference = parameter;
                if (type instanceof PsiDisjunctionType) {
                    if ((type = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
                        resolved = ((PsiClassType)type).resolve();
                    }
                } else if (type instanceof PsiClassReferenceType) {
                    PsiClassReferenceType referenceType = (PsiClassReferenceType)type;
                    resolved = referenceType.resolve();
                    reference = referenceType.getReference().getElement();
                } else if (type instanceof PsiClassType) {
                    resolved = ((PsiClassType)type).resolve();
                }
                if (resolved == null || (signature = IntellijLintUtils.getInternalName(resolved)) == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)statement, (PsiElement)this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)statement, this.myFile, ApiDetector.UNSUPPORTED)) continue;
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)reference);
                String fqcn = resolved.getName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                if (api == 19 && fqcn.equals("ReflectiveOperationException")) {
                    message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api, minSdk);
                }
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }

        private boolean isSuppressed(int api, PsiElement element, int minSdk) {
            int target;
            if (api <= minSdk) {
                return true;
            }
            if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(element, (PsiElement)this.myFile)) != -1 && api <= target) {
                return true;
            }
            if (this.mySeenSuppress && (IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.UNSUPPORTED) || IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.INLINED))) {
                return true;
            }
            if (IntellijApiDetector.isWithinVersionCheckConditional(element, api)) {
                return true;
            }
            return IntellijApiDetector.isPrecededByVersionCheckExit(element, api);
        }

        public boolean isBenignConstantUsage(PsiElement node, String name, String owner) {
            if (ApiDetector.isBenignConstantUsage(null, (String)name, (String)owner)) {
                return true;
            }
            for (PsiElement curr = node.getParent(); curr != null; curr = curr.getParent()) {
                if (curr instanceof PsiSwitchLabelStatement) {
                    PsiSwitchLabelStatement caseStatement = (PsiSwitchLabelStatement)curr;
                    PsiExpression condition = caseStatement.getCaseValue();
                    return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
                }
                if (curr instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)curr;
                    PsiExpression condition = ifStatement.getCondition();
                    return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
                }
                if (!(curr instanceof PsiConditionalExpression)) continue;
                PsiConditionalExpression ifStatement = (PsiConditionalExpression)curr;
                PsiExpression condition = ifStatement.getCondition();
                return PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
            }
            return false;
        }

        public void visitCallExpression(PsiCallExpression expression) {
            super.visitCallExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                PsiMethod containingMethod;
                PsiMethodCallExpression call;
                PsiReferenceExpression methodExpression;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String fqcn = containingClass.getQualifiedName();
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = IntellijLintUtils.getInternalMethodName(method);
                String desc = IntellijLintUtils.getInternalDescription(method, false, false);
                if (desc == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (expression instanceof PsiMethodCallExpression) {
                    PsiExpression qualifier = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
                    if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                        String expressionOwner;
                        PsiType type = qualifier.getType();
                        if (type != null && type instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type)) != null && !expressionOwner.equals(owner)) {
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (ApiLookup.isRelevantOwner((String)expressionOwner)) {
                                    return;
                                }
                            } else {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                            }
                        }
                    } else {
                        PsiElement resolved;
                        PsiQualifiedExpression pte;
                        PsiJavaCodeReferenceElement operand;
                        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                        if ((qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (operand = (pte = (PsiQualifiedExpression)qualifier).getQualifier()) != null && (resolved = operand.resolve()) instanceof PsiClass) {
                            cls = (PsiClass)resolved;
                        }
                        while (cls != null) {
                            String expressionOwner;
                            if (cls instanceof PsiAnonymousClass) {
                                boolean found = false;
                                PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                                PsiClass anonymousBase = anonymousBaseType.resolve();
                                if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                    cls = anonymousBase;
                                    found = true;
                                } else {
                                    PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                    if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                        cls = surroundingBaseType;
                                        found = true;
                                    }
                                }
                                if (!found) break;
                            }
                            if ((expressionOwner = IntellijLintUtils.getInternalName(cls)) == null) break;
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi != -1) {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                                break;
                            }
                            if (ApiLookup.isRelevantOwner((String)expressionOwner)) {
                                return;
                            }
                            cls = cls.getSuperClass();
                        }
                    }
                }
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                if (expression instanceof PsiMethodCallExpression && (methodExpression = (call = (PsiMethodCallExpression)expression).getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true)) != null && name.equals(containingMethod.getName()) && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)containingMethod) && !method.isConstructor()) {
                    return;
                }
                PsiElement locationNode = IntellijLintUtils.getCallName(expression);
                if (locationNode == null) {
                    locationNode = expression;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, locationNode);
                String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }
    }
}

