/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.inspections.lint.IntellijApiDetector;
import org.jetbrains.android.inspections.lint.IntellijGradleDetector;
import org.jetbrains.android.inspections.lint.IntellijRegistrationDetector;
import org.jetbrains.android.inspections.lint.IntellijViewTypeDetector;

public class IntellijLintIssueRegistry
extends BuiltinIssueRegistry {
    private static final Implementation DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
    private static final String CUSTOM_EXPLANATION = "When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.";
    public static final Issue CUSTOM_WARNING = Issue.create((String)"CustomWarning", (String)"Warning from Custom Rule", (String)"When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)DUMMY_IMPLEMENTATION);
    public static final Issue CUSTOM_ERROR = Issue.create((String)"CustomError", (String)"Error from Custom Rule", (String)"When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)DUMMY_IMPLEMENTATION);
    private static List<Issue> ourFilteredIssues;

    public List<Issue> getIssues() {
        if (ourFilteredIssues == null) {
            List sIssues = super.getIssues();
            ArrayList<Issue> result = new ArrayList<Issue>(sIssues.size());
            for (Issue issue : sIssues) {
                Implementation implementation = issue.getImplementation();
                EnumSet scope = implementation.getScope();
                Class detectorClass = implementation.getDetectorClass();
                if (detectorClass == ApiDetector.class) {
                    issue.setImplementation(IntellijApiDetector.IMPLEMENTATION);
                } else if (detectorClass == RegistrationDetector.class) {
                    issue.setImplementation(IntellijRegistrationDetector.IMPLEMENTATION);
                } else if (detectorClass == GradleDetector.class) {
                    issue.setImplementation(IntellijGradleDetector.IMPLEMENTATION);
                } else if (detectorClass == ViewTypeDetector.class) {
                    issue.setImplementation(IntellijViewTypeDetector.IMPLEMENTATION);
                } else {
                    if (detectorClass == SupportAnnotationDetector.class) continue;
                    if (scope.contains(Scope.CLASS_FILE) || scope.contains(Scope.ALL_CLASS_FILES) || scope.contains(Scope.JAVA_LIBRARIES)) {
                        boolean isOk = false;
                        for (EnumSet analysisScope : implementation.getAnalysisScopes()) {
                            if (analysisScope.contains(Scope.CLASS_FILE) || analysisScope.contains(Scope.ALL_CLASS_FILES) || analysisScope.contains(Scope.JAVA_LIBRARIES)) continue;
                            isOk = true;
                            break;
                        }
                        if (!isOk) continue;
                    }
                }
                result.add(issue);
            }
            ourFilteredIssues = result;
        }
        return ourFilteredIssues;
    }
}

