/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionType;

public class DescriptionCheckerUtil {
    public static PsiDirectory[] getDescriptionsDirs(Module module, DescriptionType descriptionType) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiPackage psiPackage = javaPsiFacade.findPackage(descriptionType.getDescriptionFolder());
        if (psiPackage != null) {
            return psiPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public static String getDescriptionDirName(PsiClass aClass) {
        String descriptionDir = "";
        for (PsiClass each = aClass; each != null; each = each.getContainingClass()) {
            String name = each.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return null;
            }
            descriptionDir = name + descriptionDir;
        }
        return descriptionDir;
    }
}

