/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionDescriptionInfo {
    private final String myFilename;
    private final PsiMethod myMethod;
    private final PsiFile myDescriptionFile;

    private InspectionDescriptionInfo(String filename, @Nullable PsiMethod method, @Nullable PsiFile descriptionFile) {
        this.myFilename = filename;
        this.myMethod = method;
        this.myDescriptionFile = descriptionFile;
    }

    public static InspectionDescriptionInfo create(Module module, PsiClass psiClass) {
        PsiMethod method = PsiUtil.findNearestMethod("getShortName", psiClass);
        if (method != null && DescriptionType.INSPECTION.getClassName().equals(method.getContainingClass().getQualifiedName())) {
            method = null;
        }
        String filename = method == null ? InspectionProfileEntry.getShortName((String)psiClass.getName()) : PsiUtil.getReturnedLiteral(method, psiClass);
        PsiFile descriptionFile = InspectionDescriptionInfo.resolveInspectionDescriptionFile(module, filename);
        return new InspectionDescriptionInfo(filename, method, descriptionFile);
    }

    @Nullable
    private static PsiFile resolveInspectionDescriptionFile(Module module, @Nullable String filename) {
        if (filename == null) {
            return null;
        }
        for (PsiDirectory description : DescriptionCheckerUtil.getDescriptionsDirs(module, DescriptionType.INSPECTION)) {
            VirtualFile vf;
            PsiFile file = description.findFile(filename + ".html");
            if (file == null || (vf = file.getVirtualFile()) == null || !vf.getNameWithoutExtension().equals(filename)) continue;
            return PsiManager.getInstance((Project)module.getProject()).findFile(vf);
        }
        return null;
    }

    public boolean isValid() {
        return this.myFilename != null;
    }

    public String getFilename() {
        assert (this.isValid());
        return this.myFilename;
    }

    @Nullable
    public PsiMethod getShortNameMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiFile getDescriptionFile() {
        return this.myDescriptionFile;
    }

    public boolean hasDescriptionFile() {
        return this.getDescriptionFile() != null;
    }
}

