/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionDescriptionNotFoundInspection
extends DevKitInspectionBase {
    @NonNls
    private static final String INSPECTION_PROFILE_ENTRY = DescriptionType.INSPECTION.getClassName();

    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "checkClass"));
        }
        Project project = psiClass.getProject();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(psiClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(INSPECTION_PROFILE_ENTRY, GlobalSearchScope.allScope((Project)project));
        if (base == null || !psiClass.isInheritor(base, true) || InspectionDescriptionNotFoundInspection.isPathMethodsAreOverridden(psiClass)) {
            return null;
        }
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        if (!info.isValid() || info.hasDescriptionFile()) {
            return null;
        }
        PsiElement problemElement = InspectionDescriptionNotFoundInspection.getProblemElement(psiClass, info.getShortNameMethod());
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problemElement == null ? nameIdentifier : problemElement), "Inspection does not have a description", isOnTheFly, new LocalQuickFix[]{new CreateHtmlDescriptionFix(info.getFilename(), module, DescriptionType.INSPECTION)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static PsiElement getProblemElement(PsiClass psiClass, @Nullable PsiMethod method) {
        if (method != null && method.getContainingClass() == psiClass) {
            return PsiUtil.getReturnedExpression(method);
        }
        return psiClass.getNameIdentifier();
    }

    private static boolean isPathMethodsAreOverridden(PsiClass psiClass) {
        return !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionUrl", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", INSPECTION_PROFILE_ENTRY, psiClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @NotNull String classFQN, @Nullable PsiClass psiClass) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "isLastMethodDefinitionIn"));
        }
        if (classFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFQN", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "isLastMethodDefinitionIn"));
        }
        if (psiClass == null) {
            return false;
        }
        for (PsiMethod method : psiClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return classFQN.equals(containingClass.getQualifiedName());
        }
        return InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, classFQN, psiClass.getSuperClass());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Inspection Description Checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "getDisplayName"));
        }
        return "Inspection Description Checker";
    }

    @NotNull
    public String getShortName() {
        if ("InspectionDescriptionNotFoundInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "getShortName"));
        }
        return "InspectionDescriptionNotFoundInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

