/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.reference.SoftReference;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataGroupVirtualFile;

public class TestDataGroupFileEditor
extends UserDataHolderBase
implements FileEditor {
    private WeakReference<JComponent> myComponent;
    private final TestDataGroupVirtualFile myFile;
    private final FileEditor myBeforeEditor;
    private final FileEditor myAfterEditor;

    public TestDataGroupFileEditor(Project project, TestDataGroupVirtualFile file) {
        this.myFile = file;
        this.myBeforeEditor = TextEditorProvider.getInstance().createEditor(project, file.getBeforeFile());
        this.myAfterEditor = TextEditorProvider.getInstance().createEditor(project, file.getAfterFile());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent result = (JComponent)SoftReference.dereference(this.myComponent);
        if (result == null) {
            result = this.createComponent();
            this.myComponent = new WeakReference<JComponent>(result);
        }
        JComponent jComponent = result;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "getComponent"));
        }
        return jComponent;
    }

    private JComponent createComponent() {
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getBeforeFile().getName(), this.myBeforeEditor));
        splitter.setSecondComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getAfterFile().getName(), this.myAfterEditor));
        return splitter;
    }

    private static JComponent wrapWithTitle(String name, FileEditor beforeEditor) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(name);
        label.setBorder(BorderFactory.createEmptyBorder(1, 4, 2, 0));
        label.setFont(label.getFont().deriveFont(1));
        panel.add("North", label);
        panel.add("Center", beforeEditor.getComponent());
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "setState"));
        }
    }

    public boolean isModified() {
        return this.myBeforeEditor.isModified() || this.myAfterEditor.isModified();
    }

    public boolean isValid() {
        return this.myBeforeEditor.isValid() && this.myAfterEditor.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        TextEditorProvider.getInstance().disposeEditor(this.myBeforeEditor);
        TextEditorProvider.getInstance().disposeEditor(this.myAfterEditor);
    }
}

