/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.idea.devkit.util.ActionData;

public enum ActionType {
    ACTION(AnAction.class, "action"),
    GROUP(ActionGroup.class, "group");

    public final String myClassName;
    private final String myName;

    private ActionType(Class<? extends AnAction> clazz, String name) {
        this.myClassName = clazz.getName();
        this.myName = name;
    }

    public boolean isOfType(PsiClass klass) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)klass.getProject()).findClass(this.myClassName, klass.getResolveScope());
        return psiClass != null && klass.isInheritor(psiClass, true);
    }

    public void process(XmlTag rootTag, Processor processor) {
        XmlTag[] actions;
        for (XmlTag tag : actions = rootTag.findSubTags("actions")) {
            XmlTag[] components;
            if (!tag.isPhysical()) continue;
            for (XmlTag actionOrGroup : components = tag.getSubTags()) {
                XmlTag[] groupActions;
                if (this.myName.equals(actionOrGroup.getName())) {
                    if (processor.process(this, actionOrGroup)) continue;
                    return;
                }
                if (this != ACTION || !ActionType.GROUP.myName.equals(actionOrGroup.getName())) continue;
                for (XmlTag a : groupActions = actionOrGroup.findSubTags(this.myName)) {
                    if (processor.process(this, a)) continue;
                    return;
                }
            }
        }
    }

    public void patchPluginXml(XmlFile pluginXml, PsiClass klass, ActionData dialog) throws IncorrectOperationException {
        XmlTag rootTag = pluginXml.getDocument().getRootTag();
        if (rootTag != null && "idea-plugin".equals(rootTag.getName())) {
            String firstKeyStroke;
            String groupId;
            XmlTag actions = rootTag.findFirstSubTag("actions");
            if (actions == null || !actions.isPhysical()) {
                actions = (XmlTag)rootTag.add((PsiElement)rootTag.createChildTag("actions", rootTag.getNamespace(), null, false));
            }
            XmlTag actionTag = (XmlTag)actions.add((PsiElement)actions.createChildTag(this.myName, actions.getNamespace(), null, false));
            actionTag.setAttribute("id", dialog.getActionId());
            actionTag.setAttribute("class", klass.getQualifiedName());
            actionTag.setAttribute("text", StringUtil.escapeXml((String)dialog.getActionText()));
            String description = dialog.getActionDescription();
            if (description != null && description.length() > 0) {
                actionTag.setAttribute("description", StringUtil.escapeXml((String)description));
            }
            if ((groupId = dialog.getSelectedGroupId()) != null) {
                XmlTag groupTag = (XmlTag)actionTag.add((PsiElement)actionTag.createChildTag("add-to-group", actions.getNamespace(), null, false));
                groupTag.setAttribute("group-id", groupId);
                String anchor = dialog.getSelectedAnchor();
                groupTag.setAttribute("anchor", anchor);
                if (anchor.equals("before") || anchor.equals("after")) {
                    groupTag.setAttribute("relative-to-action", dialog.getSelectedActionId());
                }
            }
            if ((firstKeyStroke = dialog.getFirstKeyStroke()) != null && firstKeyStroke.length() > 0) {
                XmlTag keyTag = (XmlTag)actionTag.add((PsiElement)actionTag.createChildTag("keyboard-shortcut", actions.getNamespace(), null, false));
                keyTag.setAttribute("keymap", "$default");
                keyTag.setAttribute("first-keystroke", firstKeyStroke);
                String secondKeyStroke = dialog.getSecondKeyStroke();
                if (secondKeyStroke != null && secondKeyStroke.length() > 0) {
                    keyTag.setAttribute("second-keystroke", secondKeyStroke);
                }
            }
        }
    }

    public static interface Processor {
        public boolean process(ActionType var1, XmlTag var2);
    }
}

