/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractActionFromEditGroup;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;

public class UneditAction
extends AbstractActionFromEditGroup {
    @Override
    public void actionPerformed(CvsContext context) {
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        int modifiedFiles = 0;
        VirtualFile firstModifiedFile = null;
        for (VirtualFile file : selectedFiles) {
            if (FileStatusManager.getInstance((Project)context.getProject()).getStatus(file) != FileStatus.MODIFIED) continue;
            if (firstModifiedFile == null) {
                firstModifiedFile = file;
            }
            ++modifiedFiles;
        }
        if (modifiedFiles > 0) {
            String message = modifiedFiles == 1 ? CvsBundle.message((String)"unedit.confirmation.single", (Object[])new Object[]{firstModifiedFile.getPresentableUrl()}) : CvsBundle.message((String)"unedit.confirmation.multiple", (Object[])new Object[]{modifiedFiles});
            if (Messages.showOkCancelDialog((Project)context.getProject(), (String)message, (String)CvsBundle.message((String)"unedit.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        super.actionPerformed(context);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.message((String)"operation.name.unedit", (Object[])new Object[0]);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        return CommandCvsHandler.createUneditHandler(context.getSelectedFiles(), CvsConfiguration.getInstance((Project)context.getProject()).MAKE_NEW_FILES_READONLY);
    }
}

