/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsContentRevision
implements ByteBackedContentRevision {
    protected final RevisionOrDate myRevision;
    protected final File myFile;
    private final FilePath myLocalFile;
    private final CvsEnvironment myEnvironment;
    private final Project myProject;
    private byte[] myContent;

    public CvsContentRevision(File file, File localFile, RevisionOrDate revision, CvsEnvironment environment, Project project) {
        this.myFile = file;
        this.myLocalFile = VcsContextFactory.SERVICE.getInstance().createFilePathOn(localFile);
        this.myRevision = revision;
        this.myEnvironment = environment;
        this.myProject = project;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] content = this.getContentAsBytes();
        return content == null ? null : CharsetToolkit.bytesToString((byte[])content, (Charset)this.myLocalFile.getCharset());
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myContent == null) {
            GetFileContentOperation operation = new GetFileContentOperation(this.myFile, this.myEnvironment, this.myRevision);
            CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
            executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"operation.name.load.file", (Object[])new Object[0]), operation), CvsOperationExecutorCallback.EMPTY);
            CvsResult result = executor.getResult();
            if (result.isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (result.hasErrors()) {
                throw result.composeError();
            }
            if (!operation.isLoaded()) {
                throw new VcsException("Network problem");
            }
            this.myContent = operation.getFileBytes();
        }
        return this.myContent;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myLocalFile;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/changeBrowser/CvsContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        CvsRevisionNumber cvsRevisionNumber = this.myRevision.getCvsRevisionNumber();
        if (cvsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/changeBrowser/CvsContentRevision", "getRevisionNumber"));
        }
        return cvsRevisionNumber;
    }

    @NonNls
    public String toString() {
        return "CvsContentRevision:" + this.myFile + "@" + this.myRevision;
    }
}

