/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsCheckOut;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutAdminReader;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;

public class CheckoutFileOperation
extends CvsOperationOnFiles {
    private final File myFile;
    private final boolean myIsDirectory;
    private final String myModuleName;
    private final RevisionOrDate myRevisionOrDate;
    private final boolean myMakeNewFilesReadOnly;

    public CheckoutFileOperation(VirtualFile parent, CvsConfiguration config, String fileName, Entry entry, boolean makeNewFilesReadOnly, boolean isDirectory) {
        this(parent, RevisionOrDateImpl.createOn(parent, entry, config.CHECKOUT_DATE_OR_REVISION_SETTINGS), fileName, makeNewFilesReadOnly, isDirectory);
    }

    public CheckoutFileOperation(VirtualFile parent, RevisionOrDate revisionOrDate, String fileName, boolean makeNewFilesReadOnly) {
        this(parent, revisionOrDate, fileName, makeNewFilesReadOnly, null);
    }

    private CheckoutFileOperation(VirtualFile parent, RevisionOrDate revisionOrDate, String fileName, boolean makeNewFilesReadOnly, Boolean isDirectory) {
        super(new CheckoutAdminReader());
        this.myMakeNewFilesReadOnly = makeNewFilesReadOnly;
        this.myRevisionOrDate = revisionOrDate;
        this.myFile = CvsVfsUtil.getFileFor(parent, fileName);
        this.myIsDirectory = isDirectory == null ? this.myFile.isDirectory() : isDirectory.booleanValue();
        this.myModuleName = CheckoutFileOperation.getModuleName(parent, fileName);
        this.addFile(this.myFile.getAbsolutePath());
    }

    private static String getModuleName(VirtualFile parent, String fileName) {
        String parentModule = CvsUtil.getModuleName(parent);
        VirtualFile file = parent.findChild(fileName);
        if (parentModule == null && file != null) {
            return CvsUtil.getModuleName(file);
        }
        return parentModule + "/" + fileName;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        CheckoutCommand result = new CheckoutCommand(null);
        result.setRecursive(true);
        result.addModule(this.myModuleName);
        this.myRevisionOrDate.setForCommand((Command)result);
        if (!this.isRoot()) {
            result.setAlternativeCheckoutDirectory(this.myIsDirectory ? this.myFile.getName() : ".");
        }
        return result;
    }

    private boolean isRoot() {
        return new File(this.myModuleName).getParentFile() == null;
    }

    @Override
    protected File getAdminRootFor(CvsRootProvider root) {
        return this.getRoot();
    }

    private File getRoot() {
        return this.myFile.getParentFile();
    }

    @Override
    public void modifyOptions(GlobalOptions options) {
        super.modifyOptions(options);
        options.setCheckedOutFilesReadOnly(this.myMakeNewFilesReadOnly);
    }

    @Override
    protected File getLocalRootFor(CvsRootProvider root) {
        File result = this.getRoot();
        LOG.assertTrue(result != null);
        return result;
    }

    @Override
    protected String getOperationName() {
        return "checkout";
    }
}

