/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.checkout.ListModulesCommand;
import org.netbeans.lib.cvsclient.command.checkout.Module;

public class GetModulesListOperation
extends LocalPathIndifferentOperation
implements DirectoryContentProvider {
    private final ListModulesCommand myCommand = new ListModulesCommand();
    private DirectoryContent myStreamingDirectoryContent = null;
    private long timeStamp = System.currentTimeMillis();
    private Consumer<DirectoryContent> myStreamingListener;

    public GetModulesListOperation(CvsEnvironment environment) {
        super(environment);
        this.addFinishAction(new Runnable(){

            @Override
            public void run() {
                if (GetModulesListOperation.this.myStreamingListener != null && GetModulesListOperation.this.myStreamingDirectoryContent.getTotalSize() > 0) {
                    GetModulesListOperation.this.myStreamingListener.consume((Object)GetModulesListOperation.this.myStreamingDirectoryContent);
                }
            }
        });
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        return this.myCommand;
    }

    public Collection<Module> getModulesInRepository() {
        return this.myCommand.getModules();
    }

    @Override
    protected String getOperationName() {
        return "checkout";
    }

    @Override
    public DirectoryContent getDirectoryContent() {
        DirectoryContent result = new DirectoryContent();
        Set modules = this.myCommand.getModules();
        for (Module module : modules) {
            result.addModule(module.getModuleName());
        }
        return result;
    }

    @Override
    public void setStreamingListener(final Consumer<DirectoryContent> streamingListener) {
        this.myStreamingListener = streamingListener;
        this.myStreamingDirectoryContent = new DirectoryContent();
        this.myCommand.setModuleConsumer((Consumer)new Consumer<Module>(){

            public void consume(Module module) {
                GetModulesListOperation.this.myStreamingDirectoryContent.addModule(module.getModuleName());
                long timePassed = System.currentTimeMillis() - GetModulesListOperation.this.timeStamp;
                if (timePassed > 25L) {
                    streamingListener.consume((Object)GetModulesListOperation.this.myStreamingDirectoryContent);
                    GetModulesListOperation.this.myStreamingDirectoryContent = new DirectoryContent();
                    GetModulesListOperation.this.timeStamp = System.currentTimeMillis();
                }
            }
        });
    }
}

