/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.util.ReflectionUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenBuildBase;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenModelBase;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProfileActivation;
import org.jetbrains.idea.maven.model.MavenProfileActivationFile;
import org.jetbrains.idea.maven.model.MavenProfileActivationOS;
import org.jetbrains.idea.maven.model.MavenProfileActivationProperty;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.embedder.CustomArtifact;
import org.sonatype.nexus.index.ArtifactInfo;

public class Maven2ModelConverter {
    public static MavenModel convertModel(Model model, File localRepository) throws RemoteException {
        Build build = model.getBuild();
        return Maven2ModelConverter.convertModel(model, Maven2ModelConverter.asSourcesList(build.getSourceDirectory()), Maven2ModelConverter.asSourcesList(build.getTestSourceDirectory()), Collections.<Artifact>emptyList(), Collections.<DependencyNode>emptyList(), Collections.<Artifact>emptyList(), localRepository);
    }

    private static List<String> asSourcesList(String directory) {
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }

    public static MavenModel convertModel(Model model, List<String> sources, List<String> testSources, Collection<Artifact> dependencies, Collection<DependencyNode> dependencyTree, Collection<Artifact> extensions, File localRepository) throws RemoteException {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven2ModelConverter.convertPlugins(model));
        THashMap convertedArtifacts = new THashMap();
        result.setExtensions(Maven2ModelConverter.convertArtifacts(extensions, (Map<Artifact, MavenArtifact>)convertedArtifacts, localRepository));
        result.setDependencies(Maven2ModelConverter.convertArtifacts(dependencies, (Map<Artifact, MavenArtifact>)convertedArtifacts, localRepository));
        result.setDependencyTree(Maven2ModelConverter.convertDependencyNodes(null, dependencyTree, (Map<Artifact, MavenArtifact>)convertedArtifacts, localRepository));
        result.setRemoteRepositories(Maven2ModelConverter.convertRepositories(model.getRepositories()));
        result.setProfiles(Maven2ModelConverter.convertProfiles(model.getProfiles()));
        result.setModules(model.getModules());
        Maven2ModelConverter.convertBuild(result.getBuild(), model.getBuild(), sources, testSources);
        return result;
    }

    private static void convertBuild(MavenBuild result, Build build, List<String> sources, List<String> testSources) {
        Maven2ModelConverter.convertBuildBase((MavenBuildBase)result, (BuildBase)build);
        result.setOutputDirectory(build.getOutputDirectory());
        result.setTestOutputDirectory(build.getTestOutputDirectory());
        result.setSources(sources);
        result.setTestSources(testSources);
    }

    private static void convertBuildBase(MavenBuildBase result, BuildBase build) {
        result.setFinalName(build.getFinalName());
        result.setDefaultGoal(build.getDefaultGoal());
        result.setDirectory(build.getDirectory());
        result.setResources(Maven2ModelConverter.convertResources(build.getResources()));
        result.setTestResources(Maven2ModelConverter.convertResources(build.getTestResources()));
        result.setFilters(build.getFilters() == null ? Collections.emptyList() : build.getFilters());
    }

    public static MavenId createMavenId(Artifact artifact) {
        return new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    private static List<MavenResource> convertResources(List<Resource> resources) {
        if (resources == null) {
            return new ArrayList<MavenResource>();
        }
        ArrayList<MavenResource> result = new ArrayList<MavenResource>(resources.size());
        for (Resource each : resources) {
            result.add(new MavenResource(each.getDirectory(), each.isFiltering(), each.getTargetPath(), Maven2ModelConverter.ensurePatterns(each.getIncludes()), Maven2ModelConverter.ensurePatterns(each.getExcludes())));
        }
        return result;
    }

    private static List<String> ensurePatterns(List<String> patterns) {
        return patterns == null ? Collections.emptyList() : patterns;
    }

    private static List<MavenRemoteRepository> convertRepositories(List<Repository> repositories) {
        if (repositories == null) {
            return new ArrayList<MavenRemoteRepository>();
        }
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(repositories.size());
        for (Repository each : repositories) {
            result.add(new MavenRemoteRepository(each.getId(), each.getName(), each.getUrl(), each.getLayout(), Maven2ModelConverter.convertPolicy(each.getReleases()), Maven2ModelConverter.convertPolicy(each.getSnapshots())));
        }
        return result;
    }

    private static MavenRemoteRepository.Policy convertPolicy(RepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    public static List<MavenArtifact> convertArtifacts(Collection<Artifact> artifacts, Map<Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        if (artifacts == null) {
            return new ArrayList<MavenArtifact>();
        }
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>(artifacts.size());
        for (Artifact each : artifacts) {
            result.add(Maven2ModelConverter.convertArtifact(each, nativeToConvertedMap, localRepository));
        }
        return result;
    }

    public static List<MavenArtifactNode> convertDependencyNodes(MavenArtifactNode parent, Collection<DependencyNode> nodes, Map<Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode each : nodes) {
            Artifact a = each.getArtifact();
            MavenArtifact ma = Maven2ModelConverter.convertArtifact(a, nativeToConvertedMap, localRepository);
            MavenArtifactState state = MavenArtifactState.ADDED;
            switch (each.getState()) {
                case 0: {
                    break;
                }
                case 2: {
                    state = MavenArtifactState.CONFLICT;
                    break;
                }
                case 1: {
                    state = MavenArtifactState.DUPLICATE;
                    break;
                }
                case 3: {
                    state = MavenArtifactState.CYCLE;
                    break;
                }
                default: {
                    assert (false) : "unknown dependency node state: " + each.getState();
                    break;
                }
            }
            MavenArtifact relatedMA = each.getRelatedArtifact() == null ? null : Maven2ModelConverter.convertArtifact(each.getRelatedArtifact(), nativeToConvertedMap, localRepository);
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, state, relatedMA, each.getOriginalScope(), each.getPremanagedVersion(), each.getPremanagedScope());
            newNode.setDependencies(Maven2ModelConverter.convertDependencyNodes(newNode, each.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }

    private static MavenArtifact convertArtifact(Artifact artifact, Map<Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        MavenArtifact result = nativeToConvertedMap.get(artifact);
        if (result == null) {
            result = Maven2ModelConverter.convertArtifact(artifact, localRepository);
            nativeToConvertedMap.put(artifact, result);
        }
        return result;
    }

    public static MavenArtifact convertArtifact(Artifact artifact, File localRepository) {
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), Maven2ModelConverter.convertExtension(artifact), artifact.getFile(), localRepository, artifact.isResolved(), artifact instanceof CustomArtifact && ((CustomArtifact)artifact).isStub());
    }

    private static String convertExtension(Artifact artifact) {
        ArtifactHandler handler = artifact.getArtifactHandler();
        String result = null;
        if (handler != null) {
            result = handler.getExtension();
        }
        if (result == null) {
            result = artifact.getType();
        }
        return result;
    }

    private static List<MavenPlugin> convertPlugins(Model mavenModel) throws RemoteException {
        ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
        THashSet pluginKeys = new THashSet();
        Build build = mavenModel.getBuild();
        Maven2ModelConverter.doConvertPlugins((PluginContainer)build, false, result, (Set<String>)pluginKeys);
        if (build != null) {
            Maven2ModelConverter.doConvertPlugins((PluginContainer)build.getPluginManagement(), true, result, (Set<String>)pluginKeys);
        }
        return result;
    }

    private static void doConvertPlugins(PluginContainer container, boolean management, List<MavenPlugin> result, Set<String> pluginKeys) throws RemoteException {
        if (container == null) {
            return;
        }
        List plugins = container.getPlugins();
        if (plugins == null) {
            return;
        }
        for (Plugin each : plugins) {
            String key = each.getGroupId() + ":" + each.getArtifactId();
            result.add(Maven2ModelConverter.convertPlugin(management, each));
            pluginKeys.add(key);
        }
    }

    private static MavenPlugin convertPlugin(boolean isDefault, Plugin plugin) throws RemoteException {
        ArrayList<MavenPlugin.Execution> executions = new ArrayList<MavenPlugin.Execution>(plugin.getExecutions().size());
        for (PluginExecution each : plugin.getExecutions()) {
            executions.add(Maven2ModelConverter.convertExecution(each));
        }
        ArrayList<MavenId> deps = new ArrayList<MavenId>(plugin.getDependencies().size());
        for (Dependency each : plugin.getDependencies()) {
            deps.add(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()));
        }
        return new MavenPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), isDefault, Maven2ModelConverter.convertConfiguration(plugin.getConfiguration()), executions, deps);
    }

    public static MavenPlugin.Execution convertExecution(PluginExecution execution) throws RemoteException {
        return new MavenPlugin.Execution(execution.getId(), execution.getGoals(), Maven2ModelConverter.convertConfiguration(execution.getConfiguration()));
    }

    private static Element convertConfiguration(Object config) throws RemoteException {
        return config == null ? null : Maven2ModelConverter.xppToElement((Xpp3Dom)config);
    }

    private static Element xppToElement(Xpp3Dom xpp) throws RemoteException {
        Element result;
        try {
            result = new Element(xpp.getName());
        }
        catch (IllegalNameException e) {
            Maven2ServerGlobals.getLogger().info(e);
            return null;
        }
        Xpp3Dom[] children = xpp.getChildren();
        if (children == null || children.length == 0) {
            result.setText(xpp.getValue());
        } else {
            for (Xpp3Dom each : children) {
                Element child = Maven2ModelConverter.xppToElement(each);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    public static List<MavenProfile> convertProfiles(Collection<Profile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProfile> result = new ArrayList<MavenProfile>();
        for (Profile each : profiles) {
            String id = each.getId();
            if (id == null) continue;
            MavenProfile profile = new MavenProfile(id, each.getSource());
            List modules = each.getModules();
            profile.setModules(modules == null ? Collections.emptyList() : modules);
            profile.setActivation(Maven2ModelConverter.convertActivation(each.getActivation()));
            if (each.getBuild() != null) {
                Maven2ModelConverter.convertBuildBase(profile.getBuild(), each.getBuild());
            }
            result.add(profile);
        }
        return result;
    }

    private static MavenProfileActivation convertActivation(Activation activation) {
        if (activation == null) {
            return null;
        }
        MavenProfileActivation result = new MavenProfileActivation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setOs(Maven2ModelConverter.convertOsActivation(activation.getOs()));
        result.setJdk(activation.getJdk());
        result.setFile(Maven2ModelConverter.convertFileActivation(activation.getFile()));
        result.setProperty(Maven2ModelConverter.convertPropertyActivation(activation.getProperty()));
        return result;
    }

    private static MavenProfileActivationOS convertOsActivation(ActivationOS os) {
        return os == null ? null : new MavenProfileActivationOS(os.getName(), os.getFamily(), os.getArch(), os.getVersion());
    }

    private static MavenProfileActivationFile convertFileActivation(ActivationFile file) {
        return file == null ? null : new MavenProfileActivationFile(file.getExists(), file.getMissing());
    }

    private static MavenProfileActivationProperty convertPropertyActivation(ActivationProperty property) {
        return property == null ? null : new MavenProfileActivationProperty(property.getName(), property.getValue());
    }

    public static Map<String, String> convertToMap(Object object) {
        try {
            THashMap result = new THashMap();
            Maven2ModelConverter.doConvert(object, "", (Map<String, String>)result);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isNativeToString(String toStringResult, Object o) {
        String className = o.getClass().getName();
        return toStringResult.startsWith(className) && toStringResult.startsWith("@", className.length());
    }

    private static void doConvert(Object object, String prefix, Map<String, String> result) throws IllegalAccessException {
        for (Field each : ReflectionUtil.collectFields(object.getClass())) {
            Package pack;
            Class<?> type = each.getType();
            if (Maven2ModelConverter.shouldSkip(type)) continue;
            each.setAccessible(true);
            Object value = each.get(object);
            if (value == null) continue;
            String name = prefix + each.getName();
            String sValue = String.valueOf(value);
            if (!Maven2ModelConverter.isNativeToString(sValue, value)) {
                result.put(name, sValue);
            }
            if ((pack = type.getPackage()) == null || !Model.class.getPackage().getName().equals(pack.getName())) continue;
            Maven2ModelConverter.doConvert(value, name + ".", result);
        }
    }

    public static boolean shouldSkip(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Xpp3Dom.class.isAssignableFrom(clazz);
    }

    public static MavenArchetype convertArchetype(Archetype archetype) {
        return new MavenArchetype(archetype.getGroupId(), archetype.getArtifactId(), archetype.getVersion(), archetype.getRepository(), archetype.getDescription());
    }

    public static Model toNativeModel(MavenModel model) {
        Model result = new Model();
        result.setArtifactId(model.getMavenId().getArtifactId());
        result.setGroupId(model.getMavenId().getGroupId());
        result.setVersion(model.getMavenId().getVersion());
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        if (model.getParent() != null) {
            Parent parent = new Parent();
            parent.setArtifactId(model.getParent().getMavenId().getArtifactId());
            parent.setGroupId(model.getParent().getMavenId().getGroupId());
            parent.setVersion(model.getParent().getMavenId().getVersion());
            parent.setRelativePath(model.getParent().getRelativePath());
            result.setParent(parent);
        }
        Maven2ModelConverter.toNativeModelBase((MavenModelBase)model, (ModelBase)result);
        result.setBuild(new Build());
        MavenBuild modelBuild = model.getBuild();
        Maven2ModelConverter.toNativeBuildBase((MavenBuildBase)modelBuild, (BuildBase)result.getBuild());
        result.getBuild().setOutputDirectory(modelBuild.getOutputDirectory());
        result.getBuild().setTestOutputDirectory(modelBuild.getTestOutputDirectory());
        if (modelBuild.getSources().size() > 1) {
            throw new RuntimeException("too many source directories: " + modelBuild.getSources());
        }
        if (modelBuild.getTestSources().size() > 1) {
            throw new RuntimeException("too many test directories: " + modelBuild.getTestSources());
        }
        if (modelBuild.getSources().size() == 1) {
            result.getBuild().setSourceDirectory((String)modelBuild.getSources().get(0));
        }
        if (modelBuild.getTestSources().size() == 1) {
            result.getBuild().setTestSourceDirectory((String)modelBuild.getTestSources().get(0));
        }
        result.setProfiles(Maven2ModelConverter.toNativeProfiles(model.getProfiles()));
        return result;
    }

    private static List<Profile> toNativeProfiles(List<MavenProfile> profiles) {
        ArrayList<Profile> result = new ArrayList<Profile>(profiles.size());
        for (MavenProfile each : profiles) {
            Profile p = new Profile();
            p.setId(each.getId());
            p.setSource(each.getSource());
            p.setBuild((BuildBase)new Build());
            p.setActivation(Maven2ModelConverter.toNativeActivation(each.getActivation()));
            Maven2ModelConverter.toNativeModelBase((MavenModelBase)each, (ModelBase)p);
            Maven2ModelConverter.toNativeBuildBase(each.getBuild(), p.getBuild());
            result.add(p);
        }
        return result;
    }

    private static Activation toNativeActivation(MavenProfileActivation activation) {
        if (activation == null) {
            return null;
        }
        Activation result = new Activation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setJdk(activation.getJdk());
        result.setOs(Maven2ModelConverter.toNativeOsActivation(activation.getOs()));
        result.setFile(Maven2ModelConverter.toNativeFileActivation(activation.getFile()));
        result.setProperty(Maven2ModelConverter.toNativePropertyActivation(activation.getProperty()));
        return result;
    }

    private static ActivationOS toNativeOsActivation(MavenProfileActivationOS os) {
        if (os == null) {
            return null;
        }
        ActivationOS result = new ActivationOS();
        result.setArch(os.getArch());
        result.setFamily(os.getFamily());
        result.setName(os.getName());
        result.setVersion(os.getVersion());
        return result;
    }

    private static ActivationFile toNativeFileActivation(MavenProfileActivationFile file) {
        if (file == null) {
            return null;
        }
        ActivationFile result = new ActivationFile();
        result.setExists(file.getExists());
        result.setMissing(file.getMissing());
        return result;
    }

    private static ActivationProperty toNativePropertyActivation(MavenProfileActivationProperty property) {
        if (property == null) {
            return null;
        }
        ActivationProperty result = new ActivationProperty();
        result.setName(property.getName());
        result.setValue(property.getValue());
        return result;
    }

    private static void toNativeModelBase(MavenModelBase from, ModelBase to) {
        to.setModules(from.getModules());
        to.setProperties(from.getProperties());
    }

    private static void toNativeBuildBase(MavenBuildBase from, BuildBase to) {
        to.setFinalName(from.getFinalName());
        to.setDefaultGoal(from.getDefaultGoal());
        to.setDirectory(from.getDirectory());
        to.setFilters(from.getFilters());
        to.setResources(Maven2ModelConverter.toNativeResources(from.getResources()));
        to.setTestResources(Maven2ModelConverter.toNativeResources(from.getTestResources()));
    }

    private static List<Resource> toNativeResources(List<MavenResource> resources) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        for (MavenResource each : resources) {
            Resource r = new Resource();
            r.setDirectory(each.getDirectory());
            r.setTargetPath(each.getTargetPath());
            r.setFiltering(each.isFiltered());
            r.setIncludes(each.getIncludes());
            r.setExcludes(each.getExcludes());
            result.add(r);
        }
        return result;
    }

    public static Repository toNativeRepository(MavenRemoteRepository r) {
        Repository result = new Repository();
        result.setId(r.getId());
        result.setName(r.getName());
        result.setUrl(r.getUrl());
        result.setLayout(r.getLayout() == null ? "default" : r.getLayout());
        if (r.getReleasesPolicy() != null) {
            result.setReleases(Maven2ModelConverter.toNativePolicy(r.getReleasesPolicy()));
        }
        if (r.getSnapshotsPolicy() != null) {
            result.setSnapshots(Maven2ModelConverter.toNativePolicy(r.getSnapshotsPolicy()));
        }
        return result;
    }

    private static RepositoryPolicy toNativePolicy(MavenRemoteRepository.Policy policy) {
        RepositoryPolicy result = new RepositoryPolicy();
        result.setEnabled(policy.isEnabled());
        result.setUpdatePolicy(policy.getUpdatePolicy());
        result.setChecksumPolicy(policy.getChecksumPolicy());
        return result;
    }

    public static MavenArtifactInfo convertArtifactInfo(ArtifactInfo a) {
        return new MavenArtifactInfo(a.groupId, a.artifactId, a.version, a.packaging, a.classifier, a.classNames, a.repository);
    }
}

