/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitSmartOperationDialog
extends DialogWrapper {
    public static final int SMART_EXIT_CODE = 0;
    public static final int FORCE_EXIT_CODE = 2;
    @NotNull
    private final JComponent myFileBrowser;
    @NotNull
    private final String myOperationTitle;
    @Nullable
    private final String myForceButton;

    static int showAndGetAnswer(final @NotNull Project project, final @NotNull JComponent fileBrowser, final @NotNull String operationTitle, final @Nullable String forceButtonTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        if (fileBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBrowser", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        final AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitSmartOperationDialog dialog = new GitSmartOperationDialog(project, fileBrowser, operationTitle, forceButtonTitle);
                ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).showDialog(dialog);
                exitCode.set(dialog.getExitCode());
            }
        });
        return exitCode.get();
    }

    private GitSmartOperationDialog(@NotNull Project project, @NotNull JComponent fileBrowser, @NotNull String operationTitle, @Nullable String forceButton) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        if (fileBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBrowser", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        super(project);
        this.myFileBrowser = fileBrowser;
        this.myOperationTitle = operationTitle;
        this.myForceButton = forceButton;
        String capitalizedOperation = StringUtil.capitalize((String)this.myOperationTitle);
        this.setTitle("Git " + capitalizedOperation + " Problem");
        this.setOKButtonText("Smart " + capitalizedOperation);
        this.getOKAction().putValue("ShortDescription", "Stash local changes, " + operationTitle + ", unstash");
        this.setCancelButtonText("Don't " + capitalizedOperation);
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        if (this.myForceButton != null) {
            Action[] actionArray = new Action[]{new ForceCheckoutAction(this.myForceButton, this.myOperationTitle)};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitSmartOperationDialog", "createLeftSideActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitSmartOperationDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JBLabel description = new JBLabel("<html>Your local changes to the following files would be overwritten by " + this.myOperationTitle + ".<br/>" + ApplicationNamesInfo.getInstance().getFullProductName() + " can stash the changes, " + this.myOperationTitle + " and unstash them after that.</html>");
        description.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)10, (int)0));
        return description;
    }

    protected JComponent createCenterPanel() {
        return this.myFileBrowser;
    }

    protected String getDimensionServiceKey() {
        return GitSmartOperationDialog.class.getName();
    }

    private class ForceCheckoutAction
    extends AbstractAction {
        ForceCheckoutAction(@NotNull String buttonTitle, String operationTitle) {
            if (buttonTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonTitle", "git4idea/branch/GitSmartOperationDialog$ForceCheckoutAction", "<init>"));
            }
            if (operationTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/branch/GitSmartOperationDialog$ForceCheckoutAction", "<init>"));
            }
            super(buttonTitle);
            this.putValue("ShortDescription", StringUtil.capitalize((String)operationTitle) + " and overwrite local changes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitSmartOperationDialog.this.close(2);
        }
    }
}

