/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.OverloadedMethods;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class OverloadedMethodsModel
implements TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final OverloadedMethods overloadedMethods;

    OverloadedMethodsModel(Object object, OverloadedMethods overloadedMethods) {
        this.object = object;
        this.overloadedMethods = overloadedMethods;
    }

    public Object exec(List arguments) throws TemplateModelException {
        MemberAndArguments maa = this.overloadedMethods.getMemberAndArguments(arguments);
        Method method = (Method)maa.getMember();
        try {
            return this.overloadedMethods.getWrapper().invokeMethod(this.object, method, maa.getArgs());
        }
        catch (Exception e) {
            Throwable t;
            while (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new TemplateModelException("Method " + method + " threw an exception. See cause exception.", e);
            }
            StringBuffer buf = new StringBuffer();
            Object[] args = maa.getArgs();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                buf.append(arg == null ? "null" : arg.getClass().getName()).append(',');
            }
            throw new TemplateModelException("Method " + method + " threw an exception when invoked on " + this.object.getClass().getName() + " object " + StringUtil.jQuote(StringUtil.tryToString(this.object)) + " with arguments of types [" + buf + "]. See cause exception.", e);
        }
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections12.singletonList(new SimpleNumber(new Integer(index))));
    }

    public int size() throws TemplateModelException {
        throw new TemplateModelException("?size is unsupported for " + this.getClass().getName());
    }
}

