/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodUtilities;
import freemarker.ext.beans.OverloadedMethodsSubset;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class OverloadedVarargMethods
extends OverloadedMethodsSubset {
    private static final Map canoncialArgPackers = new HashMap();
    private final Map argPackers = new HashMap();

    OverloadedVarargMethods() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAddSignature(Member member, Class[] argTypes) {
        ArgumentPacker argPacker = new ArgumentPacker(argTypes);
        Map map = canoncialArgPackers;
        synchronized (map) {
            ArgumentPacker canonical = (ArgumentPacker)canoncialArgPackers.get(argPacker);
            if (canonical == null) {
                canoncialArgPackers.put(argPacker, argPacker);
            } else {
                argPacker = canonical;
            }
        }
        this.argPackers.put(member, argPacker);
        OverloadedVarargMethods.componentizeLastType(argTypes);
    }

    void updateSignature(int l) {
        Class[] oneLongerTypes;
        Class[][] marshalTypes = this.getUnwrappingArgTypesByArgCount();
        Class[] newTypes = marshalTypes[l];
        int i = l;
        while (i-- > 0) {
            Class[] previousTypes = marshalTypes[i];
            if (previousTypes == null) continue;
            OverloadedVarargMethods.varArgUpdate(newTypes, previousTypes);
            break;
        }
        if (l + 1 < marshalTypes.length && (oneLongerTypes = marshalTypes[l + 1]) != null) {
            OverloadedVarargMethods.varArgUpdate(newTypes, oneLongerTypes);
        }
    }

    void afterSignatureAdded(int l) {
        Class[] oneShorterTypes;
        Class[][] marshalTypes = this.getUnwrappingArgTypesByArgCount();
        Class[] newTypes = marshalTypes[l];
        for (int i = l + 1; i < marshalTypes.length; ++i) {
            Class[] existingTypes = marshalTypes[i];
            if (existingTypes == null) continue;
            OverloadedVarargMethods.varArgUpdate(existingTypes, newTypes);
        }
        if (l > 0 && (oneShorterTypes = marshalTypes[l - 1]) != null) {
            OverloadedVarargMethods.varArgUpdate(oneShorterTypes, newTypes);
        }
    }

    private static void varArgUpdate(Class[] modifiedTypes, Class[] modifyingTypes) {
        int dl = modifiedTypes.length;
        int gl = modifyingTypes.length;
        int min = Math.min(gl, dl);
        for (int i = 0; i < min; ++i) {
            modifiedTypes[i] = MethodUtilities.getMostSpecificCommonType(modifiedTypes[i], modifyingTypes[i]);
        }
        if (dl > gl) {
            Class varArgType = modifyingTypes[gl - 1];
            for (int i = gl; i < dl; ++i) {
                modifiedTypes[i] = MethodUtilities.getMostSpecificCommonType(modifiedTypes[i], varArgType);
            }
        }
    }

    private static void componentizeLastType(Class[] types) {
        int l1 = types.length - 1;
        types[l1] = types[l1].getComponentType();
    }

    Object getMemberAndArguments(List tmArgs, BeansWrapper w) throws TemplateModelException {
        Object objMember;
        if (tmArgs == null) {
            tmArgs = Collections.EMPTY_LIST;
        }
        int l = tmArgs.size();
        Class[][] unwrappingArgTypesByArgCount = this.getUnwrappingArgTypesByArgCount();
        Object[] pojoArgs = new Object[l];
        block0: for (int j = Math.min(l + 1, unwrappingArgTypesByArgCount.length - 1); j >= 0; --j) {
            Class[] unwarappingArgTypes = unwrappingArgTypesByArgCount[j];
            if (unwarappingArgTypes == null) {
                if (j != 0) continue;
                return NO_SUCH_METHOD;
            }
            Iterator it = tmArgs.iterator();
            for (int i = 0; i < l; ++i) {
                Object pojo = w.unwrapInternal((TemplateModel)it.next(), i < j ? unwarappingArgTypes[i] : unwarappingArgTypes[j - 1]);
                if (pojo == BeansWrapper.CAN_NOT_UNWRAP) continue block0;
                if (pojo == pojoArgs[i]) continue;
                pojoArgs[i] = pojo;
            }
        }
        if ((objMember = this.getMemberForArgs(pojoArgs, true)) instanceof Member) {
            Member member = (Member)objMember;
            pojoArgs = ((ArgumentPacker)this.argPackers.get(member)).packArgs(pojoArgs, tmArgs, w);
            if (pojoArgs == null) {
                return NO_SUCH_METHOD;
            }
            BeansWrapper.coerceBigDecimals(this.getSignature(member), pojoArgs);
            return new MemberAndArguments(member, pojoArgs);
        }
        return objMember;
    }

    private static class ArgumentPacker {
        private final int argCount;
        private final Class varArgType;

        ArgumentPacker(Class[] argTypes) {
            this.argCount = argTypes.length;
            this.varArgType = argTypes[this.argCount - 1].getComponentType();
        }

        Object[] packArgs(Object[] args, List modelArgs, BeansWrapper w) throws TemplateModelException {
            int actualArgCount = args.length;
            int fixArgCount = this.argCount - 1;
            if (args.length != this.argCount) {
                Object[] newargs = new Object[this.argCount];
                System.arraycopy(args, 0, newargs, 0, fixArgCount);
                Object array = Array.newInstance(this.varArgType, actualArgCount - fixArgCount);
                for (int i = fixArgCount; i < actualArgCount; ++i) {
                    Object val = w.unwrapInternal((TemplateModel)modelArgs.get(i), this.varArgType);
                    if (val == BeansWrapper.CAN_NOT_UNWRAP) {
                        return null;
                    }
                    Array.set(array, i - fixArgCount, val);
                }
                newargs[fixArgCount] = array;
                return newargs;
            }
            Object val = w.unwrapInternal((TemplateModel)modelArgs.get(fixArgCount), this.varArgType);
            if (val == BeansWrapper.CAN_NOT_UNWRAP) {
                return null;
            }
            Object array = Array.newInstance(this.varArgType, 1);
            Array.set(array, 0, val);
            args[fixArgCount] = array;
            return args;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArgumentPacker) {
                ArgumentPacker p = (ArgumentPacker)obj;
                return this.argCount == p.argCount && this.varArgType == p.varArgType;
            }
            return false;
        }

        public int hashCode() {
            return this.argCount ^ this.varArgType.hashCode();
        }
    }
}

