/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBookmarkCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRepo;
    @Nullable
    private final String myBookmarkName;
    @NotNull
    private final HgCommandResultHandler myBookmarkResultHandler;

    public HgBookmarkCommand(@NotNull Project project, @NotNull VirtualFile repo, @Nullable String bookmarkName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgBookmarkCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgBookmarkCommand", "<init>"));
        }
        this.myProject = project;
        this.myRepo = repo;
        this.myBookmarkName = bookmarkName;
        this.myBookmarkResultHandler = new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgBookmarkCommand.this.myProject.isDisposed()) {
                    return;
                }
                HgUtil.getRepositoryManager(HgBookmarkCommand.this.myProject).updateRepository(HgBookmarkCommand.this.myRepo);
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(HgBookmarkCommand.this.myProject).notifyError(result, "Hg Error", "Hg bookmark command failed for " + HgBookmarkCommand.this.myBookmarkName);
                }
            }
        };
    }

    public void createBookmark(boolean isActive) throws HgCommandException {
        if (isActive) {
            this.executeBookmarkCommand(new String[0]);
        } else {
            this.executeBookmarkCommand("--inactive");
        }
    }

    public static void createBookmark(@NotNull List<HgRepository> repositories, @NotNull String name, boolean isActive) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/command/HgBookmarkCommand", "createBookmark"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/command/HgBookmarkCommand", "createBookmark"));
        }
        for (HgRepository repository : repositories) {
            Project project = repository.getProject();
            try {
                new HgBookmarkCommand(project, repository.getRoot(), name).createBookmark(isActive);
            }
            catch (HgCommandException exception) {
                HgErrorUtil.handleException(project, exception);
            }
        }
    }

    public void deleteBookmark() throws HgCommandException {
        this.executeBookmarkCommand("-d");
    }

    private void executeBookmarkCommand(String ... args) throws HgCommandException {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/zmlx/hg4idea/command/HgBookmarkCommand", "executeBookmarkCommand"));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myBookmarkName)) {
            throw new HgCommandException("bookmark name is empty");
        }
        ArrayList arguments = ContainerUtil.newArrayList((Object[])args);
        arguments.add(this.myBookmarkName);
        new HgCommandExecutor(this.myProject).execute(this.myRepo, "bookmark", arguments, this.myBookmarkResultHandler);
    }
}

