/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommitCommand
extends HgCommitTypeCommand {
    private final boolean myCloseBranch;
    private final boolean myShouldCommitWithSubrepos;
    @NotNull
    private List<String> mySubrepos;

    public HgCommitCommand(@NotNull Project project, @NotNull HgRepository repository, @NotNull String message, boolean amend, boolean closeBranch, boolean shouldCommitWithSubrepos) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        super(project, repository, message, amend);
        this.mySubrepos = Collections.emptyList();
        this.myCloseBranch = closeBranch;
        this.myShouldCommitWithSubrepos = shouldCommitWithSubrepos;
    }

    public HgCommitCommand(@NotNull Project project, @NotNull HgRepository repo, @NotNull String message, boolean amend) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        this(project, repo, message, amend, false, false);
    }

    public HgCommitCommand(Project project, @NotNull HgRepository repo, @NotNull String message) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        this(project, repo, message, false);
    }

    @Override
    protected void executeChunked(@NotNull List<List<String>> chunkedCommits) throws HgCommandException, VcsException {
        if (chunkedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunkedCommits", "org/zmlx/hg4idea/command/HgCommitCommand", "executeChunked"));
        }
        if (chunkedCommits.isEmpty()) {
            this.commitChunkFiles(ContainerUtil.emptyList(), this.myAmend, this.myCloseBranch);
        } else {
            int size = chunkedCommits.size();
            if (this.myShouldCommitWithSubrepos && this.myRepository.hasSubrepos()) {
                this.mySubrepos = HgUtil.getNamesWithoutHashes(this.myRepository.getSubrepos());
            }
            this.commitChunkFiles(chunkedCommits.get(0), this.myAmend, !this.mySubrepos.isEmpty(), this.myCloseBranch && size == 1);
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            boolean amendCommit = vcs != null && vcs.getVersion().isAmendSupported();
            for (int i = 1; i < size; ++i) {
                List<String> chunk = chunkedCommits.get(i);
                this.commitChunkFiles(chunk, amendCommit, false, this.myCloseBranch && i == size - 1);
            }
        }
    }

    private void commitChunkFiles(@NotNull List<String> chunk, boolean amendCommit, boolean closeBranch) throws VcsException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/zmlx/hg4idea/command/HgCommitCommand", "commitChunkFiles"));
        }
        this.commitChunkFiles(chunk, amendCommit, false, closeBranch);
    }

    private void commitChunkFiles(@NotNull List<String> chunk, boolean amendCommit, boolean withSubrepos, boolean closeBranch) throws VcsException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/zmlx/hg4idea/command/HgCommitCommand", "commitChunkFiles"));
        }
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("--logfile");
        parameters.add(this.saveCommitMessage().getAbsolutePath());
        if (withSubrepos) {
            parameters.add("-S");
            parameters.addAll(this.mySubrepos);
        } else if (amendCommit) {
            parameters.add("--amend");
        }
        if (closeBranch) {
            if (chunk.isEmpty() && this.myRepository.getState() != Repository.State.MERGING) {
                parameters.add("-X");
                parameters.add("\"**\"");
            }
            parameters.add("--close-branch");
        }
        parameters.addAll(chunk);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        HgErrorHandler.ensureSuccess(executor.executeInCurrentThread(this.myRepository.getRoot(), "commit", parameters));
    }
}

