/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryUtil {
    private static final Logger LOG = Logger.getInstance(HgHistoryUtil.class);

    private HgHistoryUtil() {
    }

    @NotNull
    public static List<VcsCommitMetadata> loadMetadata(@NotNull Project project, final @NotNull VirtualFile root, int limit, @NotNull List<String> parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "loadMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "loadMetadata"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/zmlx/hg4idea/log/HgHistoryUtil", "loadMetadata"));
        }
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<VcsCommitMetadata> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "loadMetadata"));
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtil.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        HgBaseLogParser<VcsCommitMetadata> baseParser = new HgBaseLogParser<VcsCommitMetadata>(){

            @Override
            protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (changeset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (parents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (revisionDate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionDate", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (author == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (email == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/zmlx/hg4idea/log/HgHistoryUtil$1", "convertDetails"));
                }
                String message = 1.parseAdditionalStringAttribute(attributes, 5);
                String subject = 1.extractSubject(message);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
            }
        };
        List<VcsCommitMetadata> list = HgHistoryUtil.getCommitRecords(project, result, baseParser);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "loadMetadata"));
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> history(@NotNull Project project, @NotNull VirtualFile root, int limit, @NotNull List<String> hashParameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        if (hashParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashParameters", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        List<? extends VcsFullCommitDetails> list = HgHistoryUtil.history(project, root, limit, hashParameters, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> history(final @NotNull Project project, final @NotNull VirtualFile root, final int limit, @NotNull List<String> hashParameters, final boolean silent) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        if (hashParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashParameters", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        final HgVersion version = hgvcs.getVersion();
        final String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        List list = VcsFileUtil.foreachChunk(hashParameters, (ThrowableNotNullFunction)new ThrowableNotNullFunction<List<String>, List<? extends VcsFullCommitDetails>, VcsException>(){

            @NotNull
            public List<? extends VcsFullCommitDetails> fun(@NotNull List<String> strings) throws VcsException {
                if (strings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/zmlx/hg4idea/log/HgHistoryUtil$2", "fun"));
                }
                HgCommandResult logResult = HgHistoryUtil.getLogResult(project, root, version, limit, strings, HgChangesetUtil.makeTemplate(templates));
                List<? extends VcsFullCommitDetails> list = HgHistoryUtil.createFullCommitsFromResult(project, root, logResult, version, silent);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil$2", "fun"));
                }
                return list;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "history"));
        }
        return list;
    }

    public static List<? extends VcsFullCommitDetails> createFullCommitsFromResult(@NotNull Project project, @NotNull VirtualFile root, @Nullable HgCommandResult result, @NotNull HgVersion version, boolean silent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "createFullCommitsFromResult"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "createFullCommitsFromResult"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/zmlx/hg4idea/log/HgHistoryUtil", "createFullCommitsFromResult"));
        }
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        List<HgFileRevision> hgRevisions = HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), version), silent);
        ArrayList<VcsFullCommitDetails> vcsFullCommitDetailsList = new ArrayList<VcsFullCommitDetails>();
        for (HgFileRevision revision : hgRevisions) {
            HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
            List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
            HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
            SmartList parentsHash = new SmartList();
            for (HgRevisionNumber parent : parents) {
                parentsHash.add(factory.createHash(parent.getChangeset()));
            }
            final ArrayList<Change> changes = new ArrayList<Change>();
            for (String string : revision.getModifiedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
            }
            for (String string : revision.getAddedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
            }
            for (String string : revision.getDeletedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
            }
            for (Map.Entry entry : revision.getCopiedFiles().entrySet()) {
                changes.add(HgHistoryUtil.createChange(project, root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, FileStatus.ADDED));
            }
            vcsFullCommitDetailsList.add(factory.createFullDetails(factory.createHash(vcsRevisionNumber.getChangeset()), (List)parentsHash, revision.getRevisionDate().getTime(), root, vcsRevisionNumber.getSubject(), vcsRevisionNumber.getAuthor(), vcsRevisionNumber.getEmail(), vcsRevisionNumber.getCommitMessage(), vcsRevisionNumber.getAuthor(), vcsRevisionNumber.getEmail(), revision.getRevisionDate().getTime(), (ThrowableComputable)new ThrowableComputable<Collection<Change>, Exception>(){

                public Collection<Change> compute() throws Exception {
                    return changes;
                }
            }));
        }
        return vcsFullCommitDetailsList;
    }

    @Nullable
    public static HgCommandResult getLogResult(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> parameters, @NotNull String template) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "getLogResult"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "getLogResult"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/zmlx/hg4idea/log/HgHistoryUtil", "getLogResult"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/zmlx/hg4idea/log/HgHistoryUtil", "getLogResult"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/zmlx/hg4idea/log/HgHistoryUtil", "getLogResult"));
        }
        HgFile originalHgFile = HgHistoryUtil.getOriginalHgFile(project, root);
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        ArrayList<String> args = new ArrayList<String>(parameters);
        hgLogCommand.setLogFile(false);
        if (!version.isParentRevisionTemplateSupported()) {
            args.add("--debug");
        }
        return hgLogCommand.execute(root, template, limit, originalHgFile, args);
    }

    public static HgFile getOriginalHgFile(Project project, VirtualFile root) {
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        if (project.isDisposed()) {
            return hgFile;
        }
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)project));
        return new HgFile(hgFile.getRepo(), originalFileName);
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<String, CommitInfo> converter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        List<CommitInfo> list = HgHistoryUtil.getCommitRecords(project, result, converter, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        return list;
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<String, CommitInfo> converter, boolean silent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        LinkedList revisions = new LinkedList();
        if (result == null) {
            LinkedList linkedList = revisions;
            if (linkedList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
            }
            return linkedList;
        }
        List<String> errors = result.getErrorLines();
        if (!errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                if (silent) {
                    LOG.debug(errors.toString());
                } else {
                    VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), errors.toString());
                }
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
                }
                return list;
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        List list = ContainerUtil.mapNotNull((Collection)changeSets, converter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "getCommitRecords"));
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsShortCommitDetails> readMiniDetails(final @NotNull Project project, final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "readMiniDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "readMiniDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/log/HgHistoryUtil", "readMiniDetails"));
        }
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "readMiniDetails"));
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        final HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        final String[] templates = ArrayUtil.toStringArray(templateList);
        List list = VcsFileUtil.foreachChunk(HgHistoryUtil.prepareHashes(hashes), (ThrowableNotNullFunction)new ThrowableNotNullFunction<List<String>, List<? extends VcsShortCommitDetails>, VcsException>(){

            @NotNull
            public List<? extends VcsShortCommitDetails> fun(@NotNull List<String> strings) throws VcsException {
                if (strings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/zmlx/hg4idea/log/HgHistoryUtil$4", "fun"));
                }
                HgCommandResult logResult = HgHistoryUtil.getLogResult(project, root, version, -1, strings, HgChangesetUtil.makeTemplate(templates));
                List<VcsShortCommitDetails> list = HgHistoryUtil.getCommitRecords(project, logResult, new HgBaseLogParser<VcsShortCommitDetails>(){

                    @Override
                    protected VcsShortCommitDetails convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                        if (rev == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (changeset == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (parents == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (revisionDate == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionDate", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (author == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (email == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        if (attributes == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/zmlx/hg4idea/log/HgHistoryUtil$4$1", "convertDetails"));
                        }
                        String message = 1.parseAdditionalStringAttribute(attributes, 5);
                        String subject = 1.extractSubject(message);
                        SmartList parentsHash = new SmartList();
                        for (HgRevisionNumber parent : parents) {
                            parentsHash.add(factory.createHash(parent.getChangeset()));
                        }
                        return factory.createShortDetails(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, author, email, revisionDate.getTime());
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil$4", "fun"));
                }
                return list;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "readMiniDetails"));
        }
        return list;
    }

    @NotNull
    public static List<TimedVcsCommit> readAllHashes(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<VcsUser> userRegistry, @NotNull List<String> params) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
        }
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = ArrayUtil.toStringArray(HgBaseLogParser.constructDefaultTemplate(version));
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, -1, params, HgChangesetUtil.makeTemplate(templates));
        List<TimedVcsCommit> list = HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<TimedVcsCommit>(){

            @Override
            protected TimedVcsCommit convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (changeset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (parents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (revisionDate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionDate", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (author == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (email == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/zmlx/hg4idea/log/HgHistoryUtil$5", "convertDetails"));
                }
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(author, email));
                return factory.createTimedCommit(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "readAllHashes"));
        }
        return list;
    }

    private static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(Project project) {
        if (!project.isDisposed()) {
            return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        }
        return null;
    }

    @NotNull
    public static Change createChange(@NotNull Project project, @NotNull VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        ContentRevision afterRevision;
        HgContentRevision beforeRevision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "createChange"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "createChange"));
        }
        HgContentRevision hgContentRevision = beforeRevision = fileBefore == null || aStatus == FileStatus.ADDED ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (aStatus == FileStatus.DELETED) {
            afterRevision = null;
        } else if (revisionAfter == null && fileBefore != null) {
            afterRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileAfter != null ? fileAfter : fileBefore)).toFilePath());
        } else {
            assert (revisionAfter != null);
            afterRevision = fileAfter == null ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        }
        Change change = new Change(beforeRevision, afterRevision, aStatus);
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "createChange"));
        }
        return change;
    }

    @NotNull
    public static List<String> prepareHashes(@NotNull List<String> hashes) {
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/log/HgHistoryUtil", "prepareHashes"));
        }
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        ArrayList<String> arrayList = hashArgs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "prepareHashes"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getDescendingHeadsOfBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "org/zmlx/hg4idea/log/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException("Couldn't get commit details: log command execution error.");
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        HashSet<String> hashSet = branchHeads;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        return hashSet;
    }

    public static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }
}

