/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;

public class HgEncodingUtil {
    @NotNull
    public static Charset getDefaultCharset(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgEncodingUtil", "getDefaultCharset"));
        }
        if (HgVcs.HGENCODING != null && HgVcs.HGENCODING.length() > 0 && Charset.isSupported(HgVcs.HGENCODING)) {
            Charset charset = Charset.forName(HgVcs.HGENCODING);
            if (charset == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgEncodingUtil", "getDefaultCharset"));
            }
            return charset;
        }
        Charset defaultCharset = null;
        if (!project.isDisposed()) {
            defaultCharset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        }
        Charset charset = defaultCharset != null ? defaultCharset : Charset.defaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgEncodingUtil", "getDefaultCharset"));
        }
        return charset;
    }

    @NotNull
    public static String getNameFor(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "org/zmlx/hg4idea/util/HgEncodingUtil", "getNameFor"));
        }
        String name = charset.name();
        if (name.startsWith("x-M")) {
            String string = name.substring(2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgEncodingUtil", "getNameFor"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgEncodingUtil", "getNameFor"));
        }
        return string;
    }
}

