/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

final class DnsCacheEntry {
    private final String hostname;
    private final InetAddress address;
    private final Throwable cause;
    private volatile ScheduledFuture<?> expirationFuture;

    DnsCacheEntry(String hostname, InetAddress address) {
        this.hostname = hostname;
        this.address = address;
        this.cause = null;
    }

    DnsCacheEntry(String hostname, Throwable cause) {
        this.hostname = hostname;
        this.cause = cause;
        this.address = null;
    }

    String hostname() {
        return this.hostname;
    }

    InetAddress address() {
        return this.address;
    }

    Throwable cause() {
        return this.cause;
    }

    void scheduleExpiration(EventLoop loop, Runnable task, long delay, TimeUnit unit) {
        assert (this.expirationFuture == null) : "expiration task scheduled already";
        this.expirationFuture = loop.schedule(task, delay, unit);
    }

    void cancelExpiration() {
        ScheduledFuture<?> expirationFuture = this.expirationFuture;
        if (expirationFuture != null) {
            expirationFuture.cancel(false);
        }
    }

    public String toString() {
        if (this.cause != null) {
            return this.hostname + '/' + this.cause;
        }
        return this.address.toString();
    }
}

