/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.DictionaryLookup;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoverageIOUtil {
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final byte[] ioBuffer = CoverageIOUtil.allocReadWriteUTFBuffer();
    private static final Pattern TYPE_PATTERN = Pattern.compile("(L.*;)*");

    private CoverageIOUtil() {
    }

    public static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        int i = 0;
        int i2 = 0;
        while (i < length) {
            chars[i] = (char)((bytes[i2] << 8) + (bytes[i2 + 1] & 0xFF));
            ++i;
            i2 += 2;
        }
        return new String(chars);
    }

    public static void writeString(String s, DataOutput stream) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        stream.writeInt(chars.length);
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static byte[] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTF(DataOutput storage, String value) throws IOException {
        int len = value.length();
        if (len < 255 && CoverageIOUtil.isAscii(value)) {
            CoverageIOUtil.ioBuffer[0] = (byte)len;
            for (int i = 0; i < len; ++i) {
                CoverageIOUtil.ioBuffer[i + 1] = (byte)value.charAt(i);
            }
            storage.write(ioBuffer, 0, len + 1);
        } else {
            storage.writeByte(-1);
            try {
                storage.writeUTF(value);
            }
            catch (UTFDataFormatException e) {
                storage.writeUTF(LONGER_THAN_64K_MARKER);
                CoverageIOUtil.writeString(value, storage);
            }
        }
    }

    public static String readUTFFast(DataInput storage) throws IOException {
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return CoverageIOUtil.readString(storage);
            }
            return result;
        }
        char[] chars = new char[len];
        storage.readFully(ioBuffer, 0, len);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)ioBuffer[i];
        }
        return new String(chars);
    }

    static boolean isAscii(String str) {
        for (int i = 0; i != str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0000' && c < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static int readINT(DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(DataOutput record, int val) throws IOException {
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    public static String collapse(String methodSignature, final DictionaryLookup dictionaryLookup) {
        return CoverageIOUtil.processWithDictionary(methodSignature, new Consumer(){

            protected String consume(String type) {
                int dictionaryIndex = dictionaryLookup.getDictionaryIndex(type);
                return dictionaryIndex >= 0 ? String.valueOf(dictionaryIndex) : type;
            }
        });
    }

    public static String processWithDictionary(String methodSignature, Consumer consumer) {
        Matcher matcher = TYPE_PATTERN.matcher(methodSignature);
        while (matcher.find()) {
            String s = matcher.group();
            if (!s.startsWith("L") || !s.endsWith(";")) continue;
            String type = s.substring(1, s.length() - 1);
            methodSignature = methodSignature.replace(type, consumer.consume(type));
        }
        return methodSignature;
    }

    public static DataOutputStream openFile(File file) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void close(DataOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static abstract class Consumer {
        protected abstract String consume(String var1);
    }
}

