/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestPackage
extends TestObject {
    private boolean myFoundTests = true;

    public TestPackage(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    @Override
    @NotNull
    protected JUnitProcessHandler createJUnitHandler(Executor executor) throws ExecutionException {
        JUnitProcessHandler handler = super.createJUnitHandler(executor);
        this.createSearchingForTestsTask().attachTaskToProcess((OSProcessHandler)handler);
        JUnitProcessHandler jUnitProcessHandler = handler;
        if (jUnitProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestPackage", "createJUnitHandler"));
        }
        return jUnitProcessHandler;
    }

    public SearchForTestsTask createSearchingForTestsTask() {
        final JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return new SearchForTestsTask(this.getConfiguration().getProject(), this.myServerSocket){
            private final THashSet<PsiClass> myClasses;
            {
                super(arg0, arg1);
                this.myClasses = new THashSet();
            }

            protected void search() {
                this.myClasses.clear();
                try {
                    ConfigurationUtil.findAllTestClasses(TestPackage.this.getClassFilter(data), this.myClasses);
                }
                catch (CantRunException cantRunException) {
                    // empty catch block
                }
            }

            protected void onFound() {
                TestPackage.this.myFoundTests = !this.myClasses.isEmpty();
                try {
                    TestPackage.this.addClassesListToJavaParameters(this.myClasses, new Function<PsiClass, String>(){

                        @Nullable
                        public String fun(PsiClass psiClass) {
                            return psiClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass) : null;
                        }
                    }, TestPackage.this.getPackageName(data), TestPackage.this.createTempFiles(), TestPackage.this.getJavaParameters());
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
    }

    protected boolean createTempFiles() {
        return false;
    }

    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        return this.getPackage(data).getQualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        DumbService dumbService = DumbService.getInstance((Project)this.getConfiguration().getProject());
        try {
            dumbService.setAlternativeResolveEnabled(true);
            this.getClassFilter(data);
        }
        finally {
            dumbService.setAlternativeResolveEnabled(false);
        }
        this.createTempFiles(javaParameters);
        this.createServerSocket(javaParameters);
        return javaParameters;
    }

    protected boolean configureByModule(Module module) {
        return super.configureByModule(module) && this.getConfiguration().getPersistentData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (this.getConfiguration().getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(this.filterScope(data));
    }

    protected GlobalSearchScope filterScope(final JUnitConfiguration.Data data) throws CantRunException {
        final Ref ref = new Ref();
        GlobalSearchScope aPackage = (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                try {
                    return PackageScope.packageScope((PsiPackage)TestPackage.this.getPackage(data), (boolean)true);
                }
                catch (CantRunException e) {
                    ref.set((Object)e);
                    return null;
                }
            }
        });
        CantRunException exception = (CantRunException)((Object)ref.get());
        if (exception != null) {
            throw exception;
        }
        return aPackage;
    }

    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        Project project = this.getConfiguration().getProject();
        String packageName = data.getPackageName();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        return aPackage;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        if (data.getPackageName().trim().length() > 0) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()});
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        if (!(element instanceof PsiPackage)) {
            return null;
        }
        return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return testPackage != null && Comparing.equal((String)testPackage.getQualifiedName(), (String)configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.getConfiguration().getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{packageName}));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).checkForWarning();
        }
    }

    @Override
    protected void notifyByBalloon(JUnitRunningModel model, boolean started, JUnitConsoleProperties consoleProperties) {
        if (this.myFoundTests || !ResetConfigurationModuleAdapter.tryWithAnotherModule((ModuleBasedConfiguration)this.getConfiguration(), (boolean)consoleProperties.isDebug())) {
            super.notifyByBalloon(model, started, consoleProperties);
        }
    }

    public File getWorkingDirsFile() {
        return this.myWorkingDirsFile;
    }
}

