/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.states;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.execution.junit2.states.ReadableState;
import com.intellij.execution.junit2.states.SuiteState;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FaultyState
extends ReadableState {
    private List<String> myMessages;
    private List<String> myStackTraces;

    @Override
    public void initializeFrom(ObjectReader reader) {
        this.myMessages = Collections.singletonList(reader.readLimitedString());
        this.myStackTraces = Collections.singletonList(reader.readLimitedString());
    }

    public void printOn(Printer printer) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.mark();
        for (int i = 0; i < this.myMessages.size(); ++i) {
            this.printExceptionHeader(printer, this.myMessages.get(i));
            if (i >= this.myStackTraces.size()) continue;
            printer.print(this.myStackTraces.get(i) + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    protected void printExceptionHeader(Printer printer, String message) {
        printer.print(message, ConsoleViewContentType.ERROR_OUTPUT);
    }

    @Override
    public boolean isDefect() {
        return true;
    }

    @Override
    public void merge(@NotNull TestState state, TestProxy parent) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/junit2/states/FaultyState", "merge"));
        }
        if (state instanceof FaultyState) {
            TestState parentState;
            while (parent != null && (parentState = parent.getState()) instanceof SuiteState && !((SuiteState)parentState).isRunning()) {
                parent.addLast(this);
                parent = parent.getParent();
            }
        }
    }

    @Override
    public Navigatable getDescriptor(Location<?> location) {
        if (location == null) {
            return super.getDescriptor(location);
        }
        String[] stackTrace = new LineTokenizer(this.myStackTraces.get(0)).execute();
        PsiLocation psiLocation = location.toPsiLocation();
        PsiClass containingClass = (PsiClass)psiLocation.getParentElement(PsiClass.class);
        if (containingClass == null) {
            return super.getDescriptor(location);
        }
        String containingMethod = null;
        Iterator iterator = psiLocation.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            PsiMethod psiMethod = (PsiMethod)((Location)iterator.next()).getPsiElement();
            if (!containingClass.equals(psiMethod.getContainingClass())) continue;
            containingMethod = psiMethod.getName();
        }
        if (containingMethod == null) {
            return super.getDescriptor(location);
        }
        String qualifiedName = containingClass.getQualifiedName();
        StackTraceLine lastLine = null;
        for (String aStackTrace : stackTrace) {
            StackTraceLine line = new StackTraceLine(containingClass.getProject(), aStackTrace);
            if (!containingMethod.equals(line.getMethodName()) || !qualifiedName.equals(line.getClassName())) continue;
            lastLine = line;
            break;
        }
        return lastLine != null ? lastLine.getOpenFileDescriptor(containingClass.getContainingFile().getVirtualFile()) : super.getDescriptor(location);
    }
}

