/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.bind;

import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.bind.BindConstants;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import hidden.org.apache.jackrabbit.webdav.xml.XmlSerializable;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnbindInfo
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(UnbindInfo.class);
    private String segment;

    private UnbindInfo() {
    }

    public UnbindInfo(String segment) {
        this.segment = segment;
    }

    public String getSegment() {
        return this.segment;
    }

    public static UnbindInfo createFromXml(Element root) throws DavException {
        if (!DomUtil.matches(root, "unbind", BindConstants.NAMESPACE)) {
            log.warn("DAV:unbind element expected");
            throw new DavException(400);
        }
        String segment = null;
        ElementIterator it = DomUtil.getChildren(root);
        while (it.hasNext()) {
            Element elt = it.nextElement();
            if (DomUtil.matches(elt, "segment", BindConstants.NAMESPACE)) {
                if (segment == null) {
                    segment = DomUtil.getText(elt);
                    continue;
                }
                log.warn("unexpected multiple occurence of DAV:segment element");
                throw new DavException(400);
            }
            log.warn("unexpected element " + elt.getLocalName());
            throw new DavException(400);
        }
        if (segment == null) {
            log.warn("DAV:segment element expected");
            throw new DavException(400);
        }
        return new UnbindInfo(segment);
    }

    public Element toXml(Document document) {
        Element unbindElt = DomUtil.createElement(document, "unbind", BindConstants.NAMESPACE);
        Element segElt = DomUtil.createElement(document, "segment", BindConstants.NAMESPACE, this.segment);
        unbindElt.appendChild(segElt);
        return unbindElt;
    }
}

