/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.CacheVersionKt;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.CompilationResult;
import org.jetbrains.kotlin.incremental.Difference;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl$WhenMappings;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.SubtypesMap;
import org.jetbrains.kotlin.incremental.storage.SupertypesMap;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 p*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\nopqrstuvwxB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0014\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0018\u00108\u001a\u0002062\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005H\u0002J\b\u0010<\u001a\u000206H\u0016J\u0006\u0010=\u001a\u000206J\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u000202H\u0014J\u0010\u0010B\u001a\u0002022\u0006\u0010C\u001a\u000202H\u0016J\n\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0012\u0010F\u001a\u0004\u0018\u0001022\u0006\u0010G\u001a\u000202H\u0016J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u0002020IH\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u0002020IH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010G\u001a\u000202H\u0016J\u0010\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010N\u001a\u00020OJ\u0018\u0010P\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010I2\u0006\u0010Q\u001a\u000202H\u0016J\u0014\u0010R\u001a\b\u0012\u0004\u0012\u00020O0\u00152\u0006\u0010S\u001a\u00020OJ\u000e\u0010T\u001a\u00020U2\u0006\u0010S\u001a\u00020VJ\u0014\u0010W\u001a\u0002062\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050YJ\u001e\u0010Z\u001a\u0002062\u0006\u0010S\u001a\u00020V2\f\u0010[\u001a\b\u0012\u0004\u0012\u0002020IH\u0014J7\u0010\\\u001a\u0002H]\"\u0004\b\u0001\u0010^\"\u0004\b\u0002\u0010_\"\u0014\b\u0003\u0010]*\u000e\u0012\u0004\u0012\u0002H^\u0012\u0004\u0012\u0002H_0\u001b2\u0006\u0010`\u001a\u0002H]H\u0002\u00a2\u0006\u0002\u0010aJ \u0010b\u001a\u0002062\u0006\u0010c\u001a\u0002022\u0006\u0010d\u001a\u0002022\u0006\u0010e\u001a\u000202H\u0016J\u0016\u0010f\u001a\u0002062\f\u0010g\u001a\b\u0012\u0004\u0012\u00020V0IH\u0002J\u0014\u0010h\u001a\u00020?2\f\u0010i\u001a\b\u0012\u0004\u0012\u00028\u00000jJ\u001c\u0010k\u001a\u00020?2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00050I2\u0006\u0010m\u001a\u00020\u0005J\u0014\u0010n\u001a\u000206*\u00020?2\u0006\u0010S\u001a\u00020VH\u0002R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\f0\u0019R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\f0\u001dR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\f0\u001fR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0018\u0010%\u001a\f0&R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010'\u001a\f0(R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\f0*R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\f0,R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\u00020\u0005*\u0002028DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "Target", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "target", "(Ljava/io/File;Ljava/io/File;Ljava/lang/Object;)V", "baseDir", "classFqNameToSourceMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ClassFqNameToSourceMap;", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ConstantsMap;", "dependentCaches", "", "getDependentCaches$build_common", "()Ljava/lang/Iterable;", "dependents", "Ljava/util/ArrayList;", "dependentsWithThis", "Lkotlin/sequences/Sequence;", "getDependentsWithThis", "()Lkotlin/sequences/Sequence;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "experimentalMaps", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "protoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$SourceToClassesMap;", "subtypesMap", "Lorg/jetbrains/kotlin/incremental/storage/SubtypesMap;", "supertypesMap", "Lorg/jetbrains/kotlin/incremental/storage/SupertypesMap;", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "addDependentCache", "", "cache", "addToClassStorage", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "srcFile", "clean", "cleanExperimental", "clearCacheForRemovedClasses", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "debugLog", "message", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getMultifileFacade", "partInternalName", "getObsoleteMultifileClasses", "", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "getSourceFileIfClass", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getStableMultifileFacadeParts", "facadeInternalName", "getSubtypesOf", "className", "isMultifileFacade", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "markOutputClassesDirty", "removedAndCompiledSources", "", "processChangedInlineFunctions", "changedFunctions", "registerExperimentalMap", "M", "K", "V", "map", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMap;)Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "registerInline", "fromPath", "jvmSignature", "toPath", "removeAllFromClassStorage", "removedClasses", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveModuleMappingToCache", "sourceFiles", "file", "logIfSomethingChanged", "ClassFqNameToSourceMap", "Companion", "ConstantsMap", "DirtyOutputClassesMap", "InlineFunctionsMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "SourceToClassesMap", "build-common"})
public class IncrementalCacheImpl<Target>
extends BasicMapsOwner
implements IncrementalCache {
    private final File baseDir;
    private final ArrayList<BasicMap<?, ?>> experimentalMaps;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileFacadeToParts;
    private final MultifileClassPartMap partToMultifileFacade;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final SubtypesMap subtypesMap;
    private final SupertypesMap supertypesMap;
    private final ClassFqNameToSourceMap classFqNameToSourceMap;
    private final ArrayList<IncrementalCacheImpl<Target>> dependents;
    private final Lazy<File> outputDir$delegate;
    private final File targetDataRoot;
    private static final String PROTO_MAP = "proto";
    private static final String CONSTANTS_MAP = "constants";
    private static final String PACKAGE_PARTS = "package-parts";
    private static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    private static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    private static final String SOURCE_TO_CLASSES = "source-to-classes";
    private static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String SUBTYPES = "subtypes";
    private static final String SUPERTYPES = "supertypes";
    private static final String CLASS_FQ_NAME_TO_SOURCE = "class-fq-name-to-source";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion = new Companion(null);

    private final <K, V, M extends BasicMap<K, V>> M registerExperimentalMap(M map) {
        this.experimentalMaps.add(map);
        return this.registerMap(map);
    }

    @NotNull
    protected final File getStorageFile(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new File(this.baseDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    /*
     * WARNING - void declaration
     */
    private final File getOutputDir() {
        void $receiver$iv;
        Lazy<File> lazy = this.outputDir$delegate;
        IncrementalCacheImpl incrementalCacheImpl = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (File)$receiver$iv.getValue();
    }

    @NotNull
    public final Sequence<IncrementalCacheImpl<Target>> getDependentsWithThis() {
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new IncrementalCacheImpl[]{this}), (Sequence)CollectionsKt.asSequence((Iterable)this.dependents));
    }

    @NotNull
    public final Iterable<IncrementalCacheImpl<Target>> getDependentCaches$build_common() {
        return this.dependents;
    }

    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
    }

    protected void debugLog(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
    }

    public final void addDependentCache(@NotNull IncrementalCacheImpl<Target> cache) {
        Intrinsics.checkParameterIsNotNull(cache, (String)"cache");
        this.dependents.add(cache);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver$iv;
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable iterable = classes2;
            for (Object element$iv : $receiver$iv) {
                JvmClassName it = (JvmClassName)element$iv;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
                this.dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    @NotNull
    public final Sequence<FqName> getSubtypesOf(@NotNull FqName className2) {
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        return CollectionsKt.asSequence((Iterable)this.subtypesMap.get(className2));
    }

    @Nullable
    public final File getSourceFileIfClass(@NotNull FqName fqName) {
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        return this.classFqNameToSourceMap.get(fqName);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        return this.multifileFacadeToParts.contains(string);
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = FileUtil.toSystemIndependentName((String)new File(this.getOutputDir(), internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        void $receiver$iv;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        byte[] byArray = FilesKt.readBytes((File)file);
        JvmClassName jvmClassName3 = jvmClassName2;
        ProtoMap protoMap = this.protoMap;
        Object[] objectArray = new String[0];
        protoMap.process(jvmClassName3, byArray, (String[])objectArray, false, false);
        this.dirtyOutputClassesMap.notDirty(IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable $i$f$emptyArray = sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            JvmClassName jvmClassName4 = jvmClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"jvmClassName");
            this.sourceToClassesMap.add(it, jvmClassName4);
        }
        return CompilationResult.Companion.getNO_CHANGES();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveFileToCache(@NotNull GeneratedJvmClass<Target> generatedClass) {
        CompilationResult compilationResult;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(generatedClass, (String)"generatedClass");
        Collection<File> sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = kotlinClass.getClassName();
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.sourceToClassesMap.add(it, className2);
        }
        if (kotlinClass.getClassId().isLocal()) {
            return CompilationResult.Companion.getNO_CHANGES();
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        switch (IncrementalCacheImpl$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                Unit unit;
                boolean element$iv = sourceFiles.size() == 1;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Package part from several source files: " + sourceFiles;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                this.packagePartMap.addPackagePart(className2);
                compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass, true)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
                break;
            }
            case 2: {
                Object object = kotlinClass.getClassHeader().getData();
                if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
                }
                Object partNames = object;
                this.multifileFacadeToParts.set(className2, (Collection)partNames);
                this.protoMap.remove(className2);
                FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                this.classFqNameToSourceMap.remove(fqName);
                compilationResult = this.constantsMap.process(kotlinClass, true).plus(this.inlineFunctionsMap.process(kotlinClass, true));
                break;
            }
            case 3: {
                Unit unit;
                boolean partNames = sourceFiles.size() == 1;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Multifile class part from several source files: " + sourceFiles;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                this.packagePartMap.addPackagePart(className2);
                String string2 = className2.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.internalName");
                String string3 = header.getMultifileClassName();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                this.partToMultifileFacade.set(string2, string3);
                compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass, true)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
                break;
            }
            case 4: {
                Unit unit;
                boolean value$iv = sourceFiles.size() == 1;
                if (_Assertions.ENABLED) {
                    if (!value$iv) {
                        String message$iv = "Class is expected to have only one source file: " + sourceFiles;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                this.addToClassStorage(kotlinClass, (File)CollectionsKt.first((Iterable)sourceFiles));
                compilationResult = this.protoMap.process(kotlinClass, false).plus(this.constantsMap.process(kotlinClass, true)).plus(this.inlineFunctionsMap.process(kotlinClass, false));
                break;
            }
            default: {
                compilationResult = CompilationResult.Companion.getNO_CHANGES();
            }
        }
        CompilationResult changesInfo = compilationResult;
        this.logIfSomethingChanged(changesInfo, className2);
        return changesInfo;
    }

    private final void logIfSomethingChanged(CompilationResult $receiver, JvmClassName className2) {
        if (Intrinsics.areEqual((Object)$receiver, (Object)CompilationResult.Companion.getNO_CHANGES())) {
            return;
        }
        this.debugLog(className2 + " is changed: " + $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult clearCacheForRemovedClasses() {
        void $receiver$iv;
        Collection answer$iv;
        Object value$iv;
        Iterable key$iv;
        Object facadeClassName;
        String facade;
        Object dirtyClass2;
        Object info;
        void $receiver$iv2;
        void initial$iv;
        Sequence sequence;
        CompilationResult destination$iv$iv;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Iterator p1;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv3;
        clearCacheForRemovedClasses.1 getNonPrivateNames$ = clearCacheForRemovedClasses.1.INSTANCE;
        Function1<JvmClassName, ChangeInfo> createChangeInfo$ = new Function1<JvmClassName, ChangeInfo>(this){
            final /* synthetic */ IncrementalCacheImpl this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ChangeInfo invoke(@NotNull JvmClassName className2) {
                ChangeInfo changeInfo;
                Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
                if (Intrinsics.areEqual((Object)className2.getInternalName(), (Object)org.jetbrains.kotlin.incremental.IncrementalCacheImpl$Companion.access$getMODULE_MAPPING_FILE_NAME$p(IncrementalCacheImpl.Companion))) {
                    return null;
                }
                ProtoMapValue protoMapValue = IncrementalCacheImpl.access$getProtoMap$p(this.this$0).get(className2);
                if (protoMapValue == null) {
                    return null;
                }
                ProtoMapValue mapValue = protoMapValue;
                if (mapValue.isPackageFacade()) {
                    PackageData packageData = JvmProtoBufUtil.readPackageDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Set<String> memberNames2 = clearCacheForRemovedClasses.1.INSTANCE.invoke(packageData.getPackageProto(), packageData.getNameResolver(), clearCacheForRemovedClasses.memberNames.1.INSTANCE, clearCacheForRemovedClasses.memberNames.2.INSTANCE);
                    FqName fqName = className2.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.packageFqName");
                    changeInfo = new ChangeInfo.Removed(fqName, (Collection<String>)memberNames2);
                } else {
                    List list;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    ClassData classData = JvmProtoBufUtil.readClassDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Iterable iterable = classData.getClassProto().getEnumEntryList();
                    Set<String> set = clearCacheForRemovedClasses.1.INSTANCE.invoke(classData.getClassProto(), classData.getNameResolver(), clearCacheForRemovedClasses.memberNames.3.INSTANCE, clearCacheForRemovedClasses.memberNames.4.INSTANCE, clearCacheForRemovedClasses.memberNames.5.INSTANCE);
                    void var6_9 = $receiver$iv;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        ProtoBuf.EnumEntry enumEntry = (ProtoBuf.EnumEntry)item$iv$iv;
                        list = destination$iv$iv;
                        String string = classData.getNameResolver().getString(it.getName());
                        list.add(string);
                    }
                    list = (List)destination$iv$iv;
                    Set memberNames3 = SetsKt.plus(set, (Iterable)list);
                    FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                    changeInfo = new ChangeInfo.Removed(fqName, memberNames3);
                }
                return changeInfo;
            }
            {
                this.this$0 = incrementalCacheImpl;
                super(1);
            }
        };
        Iterable iterable = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        void var5_4 = $receiver$iv3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string = (String)item$iv$iv;
            void var22_7 = destination$iv$iv2;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)((Object)p1));
            var22_7.add(jvmClassName);
        }
        List dirtyClasses = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (IncrementalCompilation.isExperimental()) {
            void $receiver$iv$iv$iv;
            void $receiver$iv4;
            Object item$iv$iv;
            $receiver$iv$iv2 = dirtyClasses;
            destination$iv$iv2 = $receiver$iv4;
            Collection collection2 = new ArrayList();
            item$iv$iv = $receiver$iv$iv;
            p1 = $receiver$iv$iv$iv.iterator();
            while (p1.hasNext()) {
                Boolean bl;
                JvmClassName it;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = p1.next();
                JvmClassName jvmClassName = it = (JvmClassName)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
                if (createChangeInfo$.invoke(jvmClassName) != null) {
                    void $receiver$iv$iv$iv2;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            sequence = CollectionsKt.asSequence((Iterable)((List)((Object)destination$iv$iv)));
        } else {
            sequence = SequencesKt.emptySequence();
        }
        Sequence changes2 = sequence;
        $receiver$iv$iv = dirtyClasses;
        destination$iv$iv = new CompilationResult(false, false, false, false, changes2, 15, null);
        CompilationResult accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv2) {
            void className2;
            element$iv$iv = (JvmClassName)element$iv;
            info = accumulator$iv;
            void v3 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"className");
            boolean bl = this.protoMap.contains((JvmClassName)v3);
            void v5 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"className");
            CompilationResult newInfo = new CompilationResult(bl, this.constantsMap.contains((JvmClassName)v5), false, false, null, 28, null);
            void v6 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"className");
            this.logIfSomethingChanged(newInfo, (JvmClassName)v6);
            accumulator$iv = ((CompilationResult)info).plus(newInfo);
        }
        CompilationResult changesInfo = accumulator$iv;
        HashMap facadesWithRemovedParts = MapsKt.hashMapOf((Pair[])new Pair[0]);
        for (Object dirtyClass2 : dirtyClasses) {
            Object object;
            void $receiver$iv5;
            String string = dirtyClass2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirtyClass.internalName");
            if (this.partToMultifileFacade.get(string) == null) {
                continue;
            }
            facadeClassName = JvmClassName.byInternalName((String)facade);
            info = facadesWithRemovedParts;
            Intrinsics.checkExpressionValueIsNotNull((Object)facadeClassName, (String)"facadeClassName");
            value$iv = $receiver$iv5.get(key$iv);
            if (value$iv == null) {
                answer$iv = SetsKt.hashSetOf((Object[])new String[0]);
                $receiver$iv5.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set removedParts = (Set)object;
            String string2 = dirtyClass2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dirtyClass.internalName");
            removedParts.add(string2);
        }
        Iterator<Object> iterator2 = facadesWithRemovedParts.entrySet().iterator();
        while (iterator2.hasNext()) {
            void destination$iv$iv3;
            void $receiver$iv$iv3;
            void $receiver$iv6;
            Collection<String> allParts;
            void $receiver$iv7;
            void $receiver$iv8;
            facadeClassName = dirtyClass2 = (Map.Entry)iterator2.next();
            facade = (JvmClassName)$receiver$iv8.getKey();
            Object $i$f$component1 = dirtyClass2;
            Set removedParts = (Set)$receiver$iv7.getValue();
            String string = facade.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facade.internalName");
            if (this.multifileFacadeToParts.get(string) == null) {
                continue;
            }
            key$iv = allParts;
            value$iv = $receiver$iv6;
            answer$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                String it = (String)element$iv$iv2;
                if (!(removedParts.contains(it) ^ true)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            List notRemovedParts = (List)destination$iv$iv3;
            if (notRemovedParts.isEmpty()) {
                String string3 = facade;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"facade");
                this.multifileFacadeToParts.remove((JvmClassName)string3);
                continue;
            }
            String string4 = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"facade");
            this.multifileFacadeToParts.set((JvmClassName)string4, notRemovedParts);
        }
        dirtyClass2 = dirtyClasses;
        for (Object element$iv : $receiver$iv) {
            JvmClassName it;
            JvmClassName jvmClassName = it = (JvmClassName)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
            this.protoMap.remove(jvmClassName);
            JvmClassName jvmClassName2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"it");
            this.packagePartMap.remove(jvmClassName2);
            JvmClassName jvmClassName3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"it");
            this.multifileFacadeToParts.remove(jvmClassName3);
            JvmClassName jvmClassName4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"it");
            this.partToMultifileFacade.remove(jvmClassName4);
            JvmClassName jvmClassName5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName5, (String)"it");
            this.constantsMap.remove(jvmClassName5);
            JvmClassName jvmClassName6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName6, (String)"it");
            this.inlineFunctionsMap.remove(jvmClassName6);
        }
        this.removeAllFromClassStorage(dirtyClasses);
        this.dirtyOutputClassesMap.clean();
        return changesInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!this.packagePartMap.isPackagePart(jvmClassName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)partInternalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(partInternalName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue $receiver$iv = protoMapValue;
            ProtoMapValue value = $receiver$iv;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet obsoleteMultifileClasses = SetsKt.linkedSetOf((Object[])new String[0]);
        for (String dirtyClass : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.partToMultifileFacade.get(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)facadeInternalName, (String)"facadeInternalName");
        Collection<String> collection = this.multifileFacadeToParts.get(facadeInternalName);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable $receiver$iv = partNames;
        Iterable iterable = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(!this.dirtyOutputClassesMap.isDirty(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public String getMultifileFacade(@NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        return this.partToMultifileFacade.get(partInternalName);
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Override
    public void clean() {
        super.clean();
        CacheVersionKt.normalCacheVersion(this.targetDataRoot).clean();
        CacheVersionKt.experimentalCacheVersion(this.targetDataRoot).clean();
    }

    public final void cleanExperimental() {
        CacheVersionKt.experimentalCacheVersion(this.targetDataRoot).clean();
        Iterable $receiver$iv = this.experimentalMaps;
        for (Object element$iv : $receiver$iv) {
            BasicMap it = (BasicMap)element$iv;
            it.clean();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassStorage(LocalFileKotlinClass kotlinClass, File srcFile) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object it;
        Object element$iv2;
        void $receiver$iv2;
        FqName it2;
        Object destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv3;
        if (!IncrementalCompilation.isExperimental()) {
            return;
        }
        String[] stringArray = kotlinClass.getClassHeader().getData();
        if (stringArray == null) {
            Intrinsics.throwNpe();
        }
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        if (stringArray2 == null) {
            Intrinsics.throwNpe();
        }
        ClassData classData = JvmProtoBufUtil.readClassDataFrom((String[])stringArray, (String[])stringArray2);
        ProtoBuf.Class clazz = classData.getClassProto();
        ProtoBuf.TypeTable typeTable = classData.getClassProto().getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classData.classProto.typeTable");
        List<ProtoBuf.Type> supertypes2 = ProtoTypeTableUtilKt.supertypes(clazz, new TypeTable(typeTable));
        Iterable iterable = supertypes2;
        void var7_6 = $receiver$iv3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            ProtoBuf.Type type = (ProtoBuf.Type)item$iv$iv;
            void var17_11 = destination$iv$iv2;
            FqName fqName = classData.getNameResolver().getClassId(it2.getClassName()).asSingleFqName();
            var17_11.add(fqName);
        }
        $receiver$iv3 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv3;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it2 = (FqName)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it2.asString(), (Object)"kotlin.Any") ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set parents = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        FqName child = kotlinClass.getClassId().asSingleFqName();
        $receiver$iv$iv2 = parents;
        for (Object element$iv2 : $receiver$iv2) {
            FqName fqName = it = (FqName)element$iv2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"it");
            FqName fqName2 = child;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"child");
            this.subtypesMap.add(fqName, fqName2);
        }
        FqName fqName = child;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"child");
        destination$iv$iv2 = this.supertypesMap.get(fqName);
        element$iv2 = $receiver$iv;
        it = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FqName it3 = (FqName)element$iv$iv;
            if (!(parents.contains(it3) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedSupertypes = (List)destination$iv$iv;
        $receiver$iv = removedSupertypes;
        for (Object element$iv3 : $receiver$iv) {
            it2 = (FqName)element$iv3;
            this.subtypesMap.removeValues(it2, SetsKt.setOf((Object)child));
        }
        FqName fqName3 = child;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"child");
        this.supertypesMap.set(fqName3, parents);
        FqName fqName4 = kotlinClass.getClassName().getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"kotlinClass.className.fq\u2026orClassNameWithoutDollars");
        this.classFqNameToSourceMap.set(fqName4, srcFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllFromClassStorage(Collection<? extends JvmClassName> removedClasses) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        if (!IncrementalCompilation.isExperimental() || removedClasses.isEmpty()) {
            return;
        }
        Iterable $receiver$iv = removedClasses;
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Iterator it;
            JvmClassName jvmClassName = (JvmClassName)item$iv$iv;
            void var12_8 = destination$iv$iv;
            FqName fqName = it.getFqNameForClassNameWithoutDollars();
            var12_8.add(fqName);
        }
        Set removedFqNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        for (IncrementalCacheImpl cache : this.getDependentsWithThis()) {
            HashSet parentsFqNames = SetsKt.hashSetOf((Object[])new FqName[0]);
            HashSet childrenFqNames = SetsKt.hashSetOf((Object[])new FqName[0]);
            for (FqName removedFqName : removedFqNames) {
                SupertypesMap supertypesMap = cache.supertypesMap;
                FqName fqName = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"removedFqName");
                parentsFqNames.addAll(supertypesMap.get(fqName));
                SubtypesMap subtypesMap = cache.subtypesMap;
                FqName fqName2 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"removedFqName");
                childrenFqNames.addAll(subtypesMap.get(fqName2));
                SupertypesMap supertypesMap2 = cache.supertypesMap;
                FqName fqName3 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"removedFqName");
                supertypesMap2.remove(fqName3);
                SubtypesMap subtypesMap2 = cache.subtypesMap;
                FqName fqName4 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"removedFqName");
                subtypesMap2.remove(fqName4);
            }
            for (FqName child : childrenFqNames) {
                SupertypesMap supertypesMap = cache.supertypesMap;
                FqName fqName = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"child");
                supertypesMap.removeValues(fqName, removedFqNames);
            }
            for (FqName parent : parentsFqNames) {
                SubtypesMap subtypesMap = cache.subtypesMap;
                FqName fqName = parent;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"parent");
                subtypesMap.removeValues(fqName, removedFqNames);
            }
        }
        $receiver$iv = removedFqNames;
        for (Object element$iv : $receiver$iv) {
            FqName it;
            FqName fqName = it = (FqName)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"it");
            this.classFqNameToSourceMap.remove(fqName);
        }
    }

    protected void processChangedInlineFunctions(@NotNull JvmClassName className2, @NotNull Collection<String> changedFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
    }

    public IncrementalCacheImpl(@NotNull File targetDataRoot, @Nullable File targetOutputDir, Target target) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        this.targetDataRoot = targetDataRoot;
        this.baseDir = new File(this.targetDataRoot, IncrementalCacheImplKt.getKOTLIN_CACHE_DIRECTORY_NAME());
        this.experimentalMaps = CollectionsKt.arrayListOf((Object[])new BasicMap[0]);
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(IncrementalCacheImpl.Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(IncrementalCacheImpl.Companion.getCONSTANTS_MAP())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(IncrementalCacheImpl.Companion.getPACKAGE_PARTS())));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(IncrementalCacheImpl.Companion.getMULTIFILE_CLASS_FACADES())));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(IncrementalCacheImpl.Companion.getMULTIFILE_CLASS_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(IncrementalCacheImpl.Companion.getINLINE_FUNCTIONS())));
        this.subtypesMap = (SubtypesMap)this.registerExperimentalMap((BasicMap)new SubtypesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getSUBTYPES())));
        this.supertypesMap = (SupertypesMap)this.registerExperimentalMap((BasicMap)new SupertypesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getSUPERTYPES())));
        this.classFqNameToSourceMap = (ClassFqNameToSourceMap)this.registerExperimentalMap((BasicMap)new ClassFqNameToSourceMap(this.getStorageFile(IncrementalCacheImpl.Companion.getCLASS_FQ_NAME_TO_SOURCE())));
        this.dependents = CollectionsKt.arrayListOf((Object[])new IncrementalCacheImpl[0]);
        this.outputDir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(targetOutputDir, target){
            final /* synthetic */ File $targetOutputDir;
            final /* synthetic */ Object $target;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final File invoke() {
                void var1_1;
                File value$iv = this.$targetOutputDir;
                if (value$iv == null) {
                    String message$iv = "Target is expected to have output directory: " + this.$target;
                    throw (Throwable)new IllegalArgumentException(message$iv.toString());
                }
                return (File)var1_1;
            }
            {
                this.$targetOutputDir = file;
                this.$target = object;
                super(0);
            }
        }));
    }

    static {
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        SUBTYPES = SUBTYPES;
        SUPERTYPES = SUPERTYPES;
        CLASS_FQ_NAME_TO_SOURCE = CLASS_FQ_NAME_TO_SOURCE;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.MAPPING_FILE_EXT;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IncrementalCacheImpl.class), "outputDir", "getOutputDir()Ljava/io/File;"))};
    }

    @NotNull
    public static final /* synthetic */ ProtoMap access$getProtoMap$p(IncrementalCacheImpl $this) {
        return $this.protoMap;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J9\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "data", "", "strings", "", "checkChangesIsOpenPart", "(Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;[B[Ljava/lang/String;ZZ)Lorg/jetbrains/kotlin/incremental/CompilationResult;", "put", "bytes", "remove", "", "build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String[] stringArray = header.getData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] bytes = BitEncoding.decodeBytes((String[])stringArray);
            JvmClassName jvmClassName = kotlinClass.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            return this.put(jvmClassName, bytes, stringArray2, isPackage, true);
        }

        @NotNull
        public final CompilationResult process(@NotNull JvmClassName className2, @NotNull byte[] data, @NotNull String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
            return this.put(className2, data, strings, isPackage, checkChangesIsOpenPart);
        }

        private final CompilationResult put(JvmClassName className2, byte[] bytes, String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            CompilationResult compilationResult;
            Collection $receiver$iv;
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            ProtoMapValue data = new ProtoMapValue(isPackage, bytes, strings);
            if (oldData == null || !Arrays.equals(bytes, oldData.getBytes()) || !Arrays.equals(strings, oldData.getStrings()) || isPackage != oldData.isPackageFacade()) {
                LazyStorage<String, ProtoMapValue> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, data);
            }
            if (oldData == null || !checkChangesIsOpenPart) {
                return new CompilationResult(true, false, false, false, null, 30, null);
            }
            Difference difference2 = ProtoDifferenceUtilsKt.difference(oldData, data);
            FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
            SmartList changeList = new SmartList();
            if (difference2.isClassAffected()) {
                FqName fqName2 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName");
                changeList.add((Object)new ChangeInfo.SignatureChanged(fqName2, difference2.getAreSubclassesAffected()));
            }
            Collection collection = difference2.getChangedMembersNames();
            if (!$receiver$iv.isEmpty()) {
                FqName fqName3 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
                changeList.add((Object)new ChangeInfo.MembersChanged(fqName3, (Collection<String>)difference2.getChangedMembersNames()));
            }
            $receiver$iv = (Collection)changeList;
            CompilationResult compilationResult2 = compilationResult;
            CompilationResult compilationResult3 = compilationResult;
            boolean bl = !$receiver$iv.isEmpty();
            compilationResult2(bl, false, false, false, CollectionsKt.asSequence((Iterable)((Iterable)changeList)), 14, null);
            return compilationResult3;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalCacheImplKt.md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u001c\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ.\u0010\u0016\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "put", "constantsMap", "remove", "", "build-common"})
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, 327680){
                final /* synthetic */ HashMap $result;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = 8 | 0x10 | 2;
                    if (value != null && (access & staticFinal) == (8 | 0x10)) {
                        void value$iv;
                        void $receiver$iv;
                        Map map = this.$result;
                        Object object = value;
                        $receiver$iv.put(name, value$iv);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 1 | 2 | 4);
            return result.isEmpty() ? (Map)null : (Map)result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getConstantsMap(kotlinClass.getFileContents()), isPackage);
        }

        /*
         * WARNING - void declaration
         */
        private final CompilationResult put(JvmClassName className2, Map<String, ? extends Object> constantsMap, boolean isPackage) {
            Sequence sequence;
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map oldMap = (Map)lazyStorage.get(string);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return CompilationResult.Companion.getNO_CHANGES();
            }
            if (constantsMap != null) {
                LazyStorage<String, Map<String, ? extends Object>> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, constantsMap);
            } else {
                this.remove(className2);
            }
            if (!IncrementalCompilation.isExperimental() || constantsMap == null || constantsMap.isEmpty() || oldMap == null || oldMap.isEmpty()) {
                sequence = SequencesKt.emptySequence();
            } else {
                Collection destination$iv$iv;
                Map.Entry it;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Map map = oldMap;
                void var9_7 = $receiver$iv;
                Map map2 = new LinkedHashMap();
                void var11_9 = $receiver$iv$iv;
                for (Map.Entry element$iv$iv : $receiver$iv$iv$iv.entrySet()) {
                    it = element$iv$iv;
                    if (!(constantsMap.containsKey(it.getKey()) && Intrinsics.areEqual((Object)constantsMap.get(it.getKey()), it.getValue()) ^ true)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $receiver$iv = destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList($receiver$iv.size());
                $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Map.Entry item$iv$iv : $receiver$iv$iv$iv.entrySet()) {
                    it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string3 = (String)it.getKey();
                    collection.add(string3);
                }
                List changedNames = (List)destination$iv$iv;
                FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
                Object[] objectArray = new ChangeInfo.MembersChanged[1];
                FqName fqName2 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName");
                objectArray[0] = new ChangeInfo.MembersChanged(fqName2, changedNames);
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            }
            Sequence changes2 = sequence;
            return new CompilationResult(false, true, false, false, changes2, 13, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "internalName", "dumpValue", "value", "get", "remove", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "set", "facadeName", "partNames", "build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void set(@NotNull JvmClassName facadeName, @NotNull Collection<String> partNames) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string = facadeName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeName.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
            return (Collection)this.getStorage().get(internalName);
        }

        public final boolean contains(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
            return this.getStorage().contains(internalName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "remove", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "set", "facadeName", "build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull String partName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            return (String)this.getStorage().get(partName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$SourceToClassesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "clearOutputsForSource", "dumpValue", "value", "get", "remove", "path", "build-common"})
    public final class SourceToClassesMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            this.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            String string2 = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.internalName");
            lazyStorage.append(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Iterable $receiver$iv = (Collection)lazyStorage.get(string);
            Collection collection = $receiver$iv;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            $receiver$iv = collection;
            Iterable $i$f$orEmpty = $receiver$iv;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                void var11_8 = destination$iv$iv;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var11_8.add(jvmClassName);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        private final void remove(String path) {
            this.getStorage().remove(path);
        }

        public SourceToClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)PathStringDescriptor.INSTANCE), (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$ClassFqNameToSourceMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "get", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "", "set", "sourceFile", "build-common"})
    public final class ClassFqNameToSourceMap
    extends BasicStringMap<String> {
        public final void set(@NotNull FqName fqName, @NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage<String, String> lazyStorage = this.getStorage();
            String string = fqName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
            String string2 = sourceFile.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceFile.canonicalPath");
            lazyStorage.set(string, string2);
        }

        @Nullable
        public final File get(@NotNull FqName fqName) {
            File file;
            Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
            LazyStorage lazyStorage = this.getStorage();
            String string = fqName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
            String string2 = (String)lazyStorage.get(string);
            if (string2 != null) {
                String $receiver$iv = string2;
                String p1 = $receiver$iv;
                file = new File(p1);
            } else {
                file = null;
            }
            return file;
        }

        public final void remove(@NotNull FqName fqName) {
            Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
            LazyStorage lazyStorage = this.getStorage();
            String string = fqName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public ClassFqNameToSourceMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)new EnumeratorStringDescriptor()), (DataExternalizer)PathStringDescriptor.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "", "value", "getDirtyOutputClasses", "", "isDirty", "className", "markDirty", "", "notDirty", "build-common"})
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        public final boolean isDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            return this.getStorage().contains(className2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", "", "build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((byte[])bytes);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, 327680, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;

                        /*
                         * WARNING - void declaration
                         */
                        public void visitEnd() {
                            void value$iv;
                            void $receiver$iv;
                            String jvmName = this.$name + this.$desc;
                            if (this.this$0.$inlineFunctions.contains(jvmName) ^ true) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalCacheImplKt.md5(dummyBytes);
                            Map map = this.this$0.$result;
                            Long l = hash;
                            $receiver$iv.put(jvmName, value$iv);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()), isPackage);
        }

        /*
         * WARNING - void declaration
         */
        private final CompilationResult put(JvmClassName className2, Map<String, Long> newMap, boolean isPackage) {
            Collection $receiver$iv;
            CompilationResult compilationResult;
            Sequence sequence;
            Object fqName;
            void $receiver$iv2;
            Object fn2;
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Set allFunctions = SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet());
            for (Object fn2 : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn2);
                Long newHash = newMap.get(fn2);
                if (oldHash == null) {
                    added.add(fn2);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn2);
            }
            fn2 = newMap;
            if (!$receiver$iv2.isEmpty()) {
                LazyStorage<String, Map<String, Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (IncrementalCompilation.isExperimental()) {
                fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
                sequence = SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)added), (Sequence)CollectionsKt.asSequence((Iterable)changed)), (Function1)((Function1)new Function1<String, ChangeInfo.MembersChanged>(fqName){
                    final /* synthetic */ FqName $fqName;

                    @NotNull
                    public final ChangeInfo.MembersChanged invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FqName fqName = this.$fqName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"fqName");
                        return new ChangeInfo.MembersChanged(fqName, CollectionsKt.listOf((Object)StringsKt.substringBefore$default((String)it, (String)"(", null, (int)2, null)));
                    }
                    {
                        this.$fqName = fqName;
                        super(1);
                    }
                }));
            } else {
                sequence = SequencesKt.emptySequence();
            }
            Sequence changes2 = sequence;
            IncrementalCacheImpl.this.processChangedInlineFunctions(className2, changed);
            fqName = changed;
            boolean bl = false;
            boolean bl2 = false;
            CompilationResult compilationResult2 = compilationResult;
            CompilationResult compilationResult3 = compilationResult;
            boolean bl3 = !$receiver$iv.isEmpty();
            $receiver$iv = added;
            boolean bl4 = !$receiver$iv.isEmpty();
            compilationResult2(bl2, bl, bl3, bl4, changes2, 3, null);
            return compilationResult3;
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl$Companion;", "", "()V", "CLASS_FQ_NAME_TO_SOURCE", "", "getCLASS_FQ_NAME_TO_SOURCE", "()Ljava/lang/String;", "CONSTANTS_MAP", "getCONSTANTS_MAP", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES", "SUBTYPES", "getSUBTYPES", "SUPERTYPES", "getSUPERTYPES", "build-common"})
    public static final class Companion {
        private final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        private final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        private final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        private final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        private final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        private final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        private final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getSUBTYPES() {
            return SUBTYPES;
        }

        private final String getSUPERTYPES() {
            return SUPERTYPES;
        }

        private final String getCLASS_FQ_NAME_TO_SOURCE() {
            return CLASS_FQ_NAME_TO_SOURCE;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

