/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

class JpsUtils {
    private static final Map<ModuleBuildTarget, Boolean> IS_KOTLIN_JS_MODULE_CACHE = JpsUtils.createMapForCaching();
    private static final Map<String, Boolean> IS_KOTLIN_JS_STDLIB_JAR_CACHE = JpsUtils.createMapForCaching();

    private JpsUtils() {
    }

    @NotNull
    static JpsJavaDependenciesEnumerator getAllDependencies(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/JpsUtils", "getAllDependencies"));
        }
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)target.isTests()));
        if (jpsJavaDependenciesEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/JpsUtils", "getAllDependencies"));
        }
        return jpsJavaDependenciesEnumerator;
    }

    static boolean isJsKotlinModule(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/JpsUtils", "isJsKotlinModule"));
        }
        Boolean cachedValue = IS_KOTLIN_JS_MODULE_CACHE.get(target);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isKotlinJsModule = JpsUtils.isJsKotlinModuleImpl(target);
        IS_KOTLIN_JS_MODULE_CACHE.put(target, isKotlinJsModule);
        return isKotlinJsModule;
    }

    private static boolean isJsKotlinModuleImpl(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/JpsUtils", "isJsKotlinModuleImpl"));
        }
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String url = root.getUrl();
                Boolean cachedValue = IS_KOTLIN_JS_STDLIB_JAR_CACHE.get(url);
                if (cachedValue != null) {
                    return cachedValue;
                }
                boolean isKotlinJavascriptStdLibrary = LibraryUtils.isKotlinJavascriptStdLibrary(JpsPathUtil.urlToFile((String)url));
                IS_KOTLIN_JS_STDLIB_JAR_CACHE.put(url, isKotlinJavascriptStdLibrary);
                if (!isKotlinJavascriptStdLibrary) continue;
                return true;
            }
        }
        return false;
    }

    private static <K, V> Map<K, V> createMapForCaching() {
        if ("true".equalsIgnoreCase(System.getProperty("kotlin.jps.tests"))) {
            return new AbstractMap<K, V>(){

                @Override
                public V put(K key, V value) {
                    return null;
                }

                @Override
                public V get(Object key) {
                    return null;
                }

                @Override
                @NotNull
                public Set<Map.Entry<K, V>> entrySet() {
                    Set set = Collections.emptySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/JpsUtils$1", "entrySet"));
                    }
                    return set;
                }
            };
        }
        return new ConcurrentHashMap();
    }
}

