/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.Interpreter;

public class ControlFlowGraph {
    private Map<AbstractInsnNode, Node> mNodeMap;
    private MethodNode mMethod;
    private static Map<Object, String> sIds = null;
    private static int sNextId = 1;
    private static String[] sOpcodeNames;

    public static ControlFlowGraph create(ControlFlowGraph initial, ClassNode classNode, MethodNode method) throws AnalyzerException {
        final ControlFlowGraph graph = initial != null ? initial : new ControlFlowGraph();
        final InsnList instructions = method.instructions;
        graph.mNodeMap = Maps.newHashMapWithExpectedSize((int)instructions.size());
        graph.mMethod = method;
        Analyzer analyzer = new Analyzer((Interpreter)new BasicInterpreter()){

            protected void newControlFlowEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.add(from, to);
            }

            protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
                AbstractInsnNode from = instructions.get(insn);
                graph.exception(from, tcb);
                return super.newControlFlowExceptionEdge(insn, tcb);
            }

            protected boolean newControlFlowExceptionEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.exception(from, to);
                return super.newControlFlowExceptionEdge(insn, successor);
            }
        };
        analyzer.analyze(classNode.name, method);
        return graph;
    }

    private boolean isConnected(Node from, Node to, Set<Node> seen) {
        if (from == to) {
            return true;
        }
        if (seen.contains(from)) {
            return false;
        }
        seen.add(from);
        List<Node> successors = from.successors;
        List<Node> exceptions = from.exceptions;
        if (exceptions != null) {
            for (Node successor : exceptions) {
                if (!this.isConnected(successor, to, seen)) continue;
                return true;
            }
        }
        if (successors != null) {
            for (Node successor : successors) {
                if (!this.isConnected(successor, to, seen)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnected(Node from, Node to) {
        return this.isConnected(from, to, Sets.newIdentityHashSet());
    }

    public boolean isConnected(AbstractInsnNode from, AbstractInsnNode to) {
        return this.isConnected(this.getNode(from), this.getNode(to));
    }

    protected void add(AbstractInsnNode from, AbstractInsnNode to) {
        this.getNode(from).addSuccessor(this.getNode(to));
    }

    protected void exception(AbstractInsnNode from, AbstractInsnNode to) {
    }

    protected void exception(AbstractInsnNode from, TryCatchBlockNode tcb) {
        LabelNode start = tcb.start;
        LabelNode end = tcb.end;
        Node handlerNode = this.getNode((AbstractInsnNode)tcb.handler);
        for (LabelNode curr = start; curr != end && curr != null; curr = curr.getNext()) {
            if (curr.getType() != 5 && (curr.getType() != 0 || curr.getOpcode() != 191)) continue;
            if (tcb.type == null) {
                this.getNode((AbstractInsnNode)curr).addSuccessor(handlerNode);
            }
            this.getNode((AbstractInsnNode)curr).addExceptionPath(handlerNode);
        }
    }

    public Node getNode(AbstractInsnNode instruction) {
        Node node = this.mNodeMap.get(instruction);
        if (node == null) {
            node = new Node(instruction);
            this.mNodeMap.put(instruction, node);
        }
        return node;
    }

    public String toString(Node start) {
        AbstractInsnNode curr;
        StringBuilder sb = new StringBuilder(400);
        if (start != null) {
            curr = start.instruction;
        } else {
            if (this.mNodeMap.isEmpty()) {
                return "<empty>";
            }
            curr = this.mNodeMap.keySet().iterator().next();
            while (curr.getPrevious() != null) {
                curr = curr.getPrevious();
            }
        }
        while (curr != null) {
            Node node = this.mNodeMap.get(curr);
            if (node != null) {
                sb.append(node.toString(true));
            }
            curr = curr.getNext();
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    private static String getId(Object object) {
        String id;
        if (sIds == null) {
            sIds = Maps.newHashMap();
        }
        if ((id = sIds.get(object)) == null) {
            id = Integer.toString(sNextId++);
            sIds.put(object, id);
        }
        return id;
    }

    public String toDot(Set<Node> highlight) {
        AbstractInsnNode instruction;
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n");
        sb.append("  start -> ").append(ControlFlowGraph.getId(this.mNodeMap.get(instruction))).append(";\n");
        sb.append("  start [shape=plaintext];\n");
        for (instruction = this.mMethod.instructions.getFirst(); instruction != null; instruction = instruction.getNext()) {
            Node node = this.mNodeMap.get(instruction);
            if (node == null) continue;
            if (node.successors != null) {
                for (Node to : node.successors) {
                    sb.append("  ").append(ControlFlowGraph.getId(node)).append(" -> ").append(ControlFlowGraph.getId(to));
                    if (node.instruction instanceof JumpInsnNode) {
                        sb.append(" [label=\"");
                        if (((JumpInsnNode)node.instruction).label == to.instruction) {
                            sb.append("yes");
                        } else {
                            sb.append("no");
                        }
                        sb.append("\"]");
                    }
                    sb.append(";\n");
                }
            }
            if (node.exceptions == null) continue;
            for (Node to : node.exceptions) {
                sb.append(ControlFlowGraph.getId(node)).append(" -> ").append(ControlFlowGraph.getId(to));
                sb.append(" [label=\"exception\"];\n");
            }
        }
        sb.append("\n");
        for (Node node : this.mNodeMap.values()) {
            instruction = node.instruction;
            sb.append("  ").append(ControlFlowGraph.getId(node)).append(" ");
            sb.append("[label=\"").append(ControlFlowGraph.dotDescribe(node)).append("\"");
            if (highlight != null && highlight.contains(node)) {
                sb.append(",shape=box,style=filled");
            } else if (instruction instanceof LineNumberNode || instruction instanceof LabelNode || instruction instanceof FrameNode) {
                sb.append(",shape=oval,style=dotted");
            } else {
                sb.append(",shape=box");
            }
            sb.append("];\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String dotDescribe(Node node) {
        AbstractInsnNode instruction = node.instruction;
        if (instruction instanceof LabelNode) {
            return "Label";
        }
        if (instruction instanceof LineNumberNode) {
            LineNumberNode lineNode = (LineNumberNode)instruction;
            return "Line " + lineNode.line;
        }
        if (instruction instanceof FrameNode) {
            return "Stack Frame";
        }
        if (instruction instanceof MethodInsnNode) {
            MethodInsnNode method = (MethodInsnNode)instruction;
            String cls = method.owner.substring(method.owner.lastIndexOf(47) + 1);
            cls = cls.replace('$', '.');
            return "Call " + cls + "#" + method.name;
        }
        if (instruction instanceof FieldInsnNode) {
            FieldInsnNode field = (FieldInsnNode)instruction;
            String cls = field.owner.substring(field.owner.lastIndexOf(47) + 1);
            cls = cls.replace('$', '.');
            return "Field " + cls + "#" + field.name;
        }
        if (instruction instanceof TypeInsnNode && instruction.getOpcode() == 187) {
            return "New " + ((TypeInsnNode)instruction).desc;
        }
        StringBuilder sb = new StringBuilder();
        String opcodeName = ControlFlowGraph.getOpcodeName(instruction.getOpcode());
        sb.append(opcodeName);
        if (instruction instanceof IntInsnNode) {
            IntInsnNode in = (IntInsnNode)instruction;
            sb.append(" ").append(Integer.toString(in.operand));
        } else if (instruction instanceof LdcInsnNode) {
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            sb.append(" ");
            if (ldc.cst instanceof String) {
                sb.append("\\\"");
            }
            sb.append(ldc.cst);
            if (ldc.cst instanceof String) {
                sb.append("\\\"");
            }
        }
        return sb.toString();
    }

    private static String getOpcodeName(int opcode) {
        String name;
        if (sOpcodeNames == null) {
            sOpcodeNames = new String[255];
            try {
                Field[] fields;
                for (Field field : fields = Opcodes.class.getDeclaredFields()) {
                    int val;
                    String name2;
                    if (field.getType() != Integer.TYPE || (name2 = field.getName()).startsWith("ASM") || name2.startsWith("V1_") || name2.startsWith("ACC_") || name2.startsWith("T_") || name2.startsWith("H_") || name2.startsWith("F_") || (val = field.getInt(null)) < 0 || val >= sOpcodeNames.length) continue;
                    ControlFlowGraph.sOpcodeNames[val] = field.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (opcode >= 0 && opcode < sOpcodeNames.length && (name = sOpcodeNames[opcode]) != null) {
            return name;
        }
        return Integer.toString(opcode);
    }

    public static class Node {
        public final AbstractInsnNode instruction;
        public final List<Node> successors = new ArrayList<Node>(2);
        public final List<Node> exceptions = new ArrayList<Node>(1);
        public int visit;

        public Node(AbstractInsnNode instruction) {
            this.instruction = instruction;
        }

        void addSuccessor(Node node) {
            if (!this.successors.contains(node)) {
                this.successors.add(node);
            }
        }

        void addExceptionPath(Node node) {
            if (!this.exceptions.contains(node)) {
                this.exceptions.add(node);
            }
        }

        public String toString(boolean includeAdjacent) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(ControlFlowGraph.getId(this.instruction));
            sb.append(':');
            if (this.instruction instanceof LabelNode) {
                sb.append("LABEL");
            } else if (this.instruction instanceof LineNumberNode) {
                sb.append("LINENUMBER ").append(((LineNumberNode)this.instruction).line);
            } else if (this.instruction instanceof FrameNode) {
                sb.append("FRAME");
            } else {
                int opcode = this.instruction.getOpcode();
                String opcodeName = ControlFlowGraph.getOpcodeName(opcode);
                sb.append(opcodeName);
                if (this.instruction.getType() == 5) {
                    sb.append('(').append(((MethodInsnNode)this.instruction).name).append(')');
                }
            }
            if (includeAdjacent) {
                if (this.successors != null && !this.successors.isEmpty()) {
                    sb.append(" Next:");
                    for (Node successor : this.successors) {
                        sb.append(' ');
                        sb.append(successor.toString(false));
                    }
                }
                if (this.exceptions != null && !this.exceptions.isEmpty()) {
                    sb.append(" Exceptions:");
                    for (Node exception : this.exceptions) {
                        sb.append(' ');
                        sb.append(exception.toString(false));
                    }
                }
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

