/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

@Beta
public enum Severity {
    FATAL("Fatal"),
    ERROR("Error"),
    WARNING("Warning"),
    INFORMATIONAL("Information"),
    IGNORE("Ignore");

    private final String mDisplay;

    private Severity(String display) {
        this.mDisplay = display;
    }

    public String getDescription() {
        return this.mDisplay;
    }

    public String getName() {
        return this.name();
    }

    public static Severity fromName(String name) {
        for (Severity severity : Severity.values()) {
            if (!severity.name().equalsIgnoreCase(name)) continue;
            return severity;
        }
        return null;
    }
}

